/*******************************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolException.java,v 1.5 2009/03/04 17:50:49 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * <p>Datapool exception represent errors and exceptions that can be thrown
 * when working with datapools (see {@link IDatapool}).</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 4, 3009
 * @since   January 25, 2005
 */
public class DatapoolException extends RuntimeException{

	/**
	 * Serial version ID.
	 */
	private static final long serialVersionUID = 3257845502291751480L;
	
	/**
	 * <p>Constructs a new datapool exception with no detailed message.</p>
	 * 
	 * @see RuntimeException#RuntimeException()
	 */
	public DatapoolException(){
		super();
	}
	
	/**
	 * <p>Constructs a new datapool exception with a detailed message.</p>
	 * 
	 * @param message The datapool exception's detailed message.
	 * @see   RuntimeException#RuntimeException(String)
	 */
	public DatapoolException(String message){
		super(message);
	}
	
	/**
	 * <p>Constructs a new datapool exception with a detailed message
	 * and a cause.</p>
	 * 
	 * @param message The datapool exception's detailed message.
	 * @param cause The datapool exception's cause.
	 * @see   RuntimeException#RuntimeException(String, Throwable)
	 */
	/**
	 * @param message
	 * @param cause
	 */
	public DatapoolException(String message, Throwable cause){
		super(message, cause);
	}
}
