/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLtimedEventLoader.java,v 1.3 2006/02/08 19:59:50 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author akmathur
 *
 * This is the TPFTimedEvent loader.
 */
public class XMLtimedEventLoader extends XMLexecutionEventLoader {
	
	protected final static String EVENT_TIMED_END_TIMESTAMP = "endTimestamp";
	protected long endTimestamp = -1;
		
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		endTimestamp = -1;
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_TIMED_END_TIMESTAMP_int :
			endTimestamp = Long.parseLong(value);
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/**
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Event could have been created by the extended class XMLwaitEventLoader
		TPFTimedEvent event = (TPFTimedEvent) this.event;
		
		// If this is really a timed event, then Create the event
		if (event == null) {
			event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFTimedEvent();
		}
		
		// Now populate the specialized attributes
		event.setEndTimestamp(endTimestamp);
		
		// populate the event with the base event attributes
		this.event = event;
		super.addYourselfInContext();
		super.addYourselfToContainer();
	}
	
	/**
	 * @see org.eclipse.hyades.loaders.common.XMLexecutionEventLoader#overwrite(org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent)
	 */
	protected void overwrite(TPFExecutionEvent match) {		
		// Overwrite specific event properties
		((TPFTimedEvent) match).setEndTimestamp(((TPFTimedEvent) event).getEndTimestamp());
		// Overwrite basic event properties
		super.overwrite(match);
	}
}
