/**********************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestlogFilenameExtensionManager.java,v 1.1 2009/04/27 15:21:31 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common.provisional;

import java.util.HashMap;
import java.util.HashSet;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/**
 * This class provides information about the testlog_filename_extension extension point.
 * This extension point allows a test type to register a different file extension for 
 * its test logs.  A test type may do this in order to provide a different EMF 
 * ResourceImpl for its test logs.  This singleton class is used by the workbench-side 
 * test execution components to determine if a given test type wants to provide
 * its own file extension for its test logs.
 *   
 * @author ejessee
 *
 */
public class TestlogFilenameExtensionManager
{
	private static TestlogFilenameExtensionManager instance = null;
	private static String IID="org.eclipse.tptp.platform.models.testlog_filename_extension";
	private static String EXT_VAL_ATTRIBUTE="value";
	private static String TEST_TYPE_ELEMENT_NAME="testtype";
	private static String TEST_TYPE_NAME_ATTRIBUTE="name";
	private IConfigurationElement[] testLogFilenameExtensions=null;
	private HashMap extensionMap = new HashMap();
	private static final boolean DISABLE_CUSTOM_EXTENSIONS = System.getProperty("tptpDisableCustomTestLogExtensions")!=null && 
		System.getProperty("tptpDisableCustomTestLogExtensions").equals("true"); 
	
	private TestlogFilenameExtensionManager()
	{
		testLogFilenameExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(IID);
		if (!DISABLE_CUSTOM_EXTENSIONS)
		{
			for (int i = 0; i < testLogFilenameExtensions.length; i++) {
				IConfigurationElement providedExtension = testLogFilenameExtensions[i];
				String extension = providedExtension.getAttribute(EXT_VAL_ATTRIBUTE);
				IConfigurationElement[] testTypes = providedExtension.getChildren(TEST_TYPE_ELEMENT_NAME);
				
				for (int j = 0; j < testTypes.length; j++) {
					IConfigurationElement testType = testTypes[j];
					String testTypeName = testType.getAttribute(TEST_TYPE_NAME_ATTRIBUTE);
					extensionMap.put(testTypeName, extension);
				}
				
			}
		}		
	}

	public static TestlogFilenameExtensionManager getInstance()
	{
		if(instance==null)
			instance = new TestlogFilenameExtensionManager();
		return instance;
	}
	
	public String getExtensionForTestType(String testType)
	{
		return (String) extensionMap.get(testType);
	}
	
	public String[] getAllRegisteredLogExtensions()
	{
		if(extensionMap.values().size()>0) {
			// Need to make this collection unique -- use a set
			HashSet set = new HashSet(extensionMap.values());
			return (String[]) set.toArray(new String[0]);
		}
		else
			return null;
	}

}
