/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CommonPackage.java,v 1.8 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.common;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Internal package, please do not extend or use.
 * The common pacakge provides the base classes that are similar to the UML concepts for defining classes and behaviour. This package is not intended to provide a general meta model for these concepts. It will be replaced if a UML model were to  appear in Eclipse that can be used.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.common.common.CommonFactory
 * @model kind="package"
 * @generated
 */
public interface CommonPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "common";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/common.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Common";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CommonPackage eINSTANCE = org.eclipse.hyades.models.common.common.impl.CommonPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl <em>CMN Named Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNamedElement()
	 * @generated
	 */
	int CMN_NAMED_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NAMED_ELEMENT__ID = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NAMED_ELEMENT__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NAMED_ELEMENT__NAME = 2;

	/**
	 * The number of structural features of the '<em>CMN Named Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NAMED_ELEMENT_FEATURE_COUNT = 3;


	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNodeTypeImpl <em>CMN Node Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNNodeTypeImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNodeType()
	 * @generated
	 */
	int CMN_NODE_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__ID = Common_ConfigurationPackage.CFG_LOCATION__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__DESCRIPTION = Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__NAME = Common_ConfigurationPackage.CFG_LOCATION__NAME;

	/**
	 * The feature id for the '<em><b>Property Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__PROPERTY_GROUPS = Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__DEPLOYMENT = Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__TIMEZONE = Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE;

	/**
	 * The feature id for the '<em><b>Sub Locations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__SUB_LOCATIONS = Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__PARENT = Common_ConfigurationPackage.CFG_LOCATION__PARENT;

	/**
	 * The feature id for the '<em><b>Ref Sub Locations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__REF_SUB_LOCATIONS = Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Hostname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE__HOSTNAME = Common_ConfigurationPackage.CFG_LOCATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>CMN Node Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_TYPE_FEATURE_COUNT = Common_ConfigurationPackage.CFG_LOCATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNMachineImpl <em>CMN Machine</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNMachineImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNMachine()
	 * @generated
	 */
	int CMN_MACHINE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__ID = CMN_NODE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__DESCRIPTION = CMN_NODE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__NAME = CMN_NODE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Property Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__PROPERTY_GROUPS = CMN_NODE_TYPE__PROPERTY_GROUPS;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__DEPLOYMENT = CMN_NODE_TYPE__DEPLOYMENT;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__TIMEZONE = CMN_NODE_TYPE__TIMEZONE;

	/**
	 * The feature id for the '<em><b>Sub Locations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__SUB_LOCATIONS = CMN_NODE_TYPE__SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__PARENT = CMN_NODE_TYPE__PARENT;

	/**
	 * The feature id for the '<em><b>Ref Sub Locations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__REF_SUB_LOCATIONS = CMN_NODE_TYPE__REF_SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Hostname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE__HOSTNAME = CMN_NODE_TYPE__HOSTNAME;

	/**
	 * The number of structural features of the '<em>CMN Machine</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_MACHINE_FEATURE_COUNT = CMN_NODE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNodeInstanceImpl <em>CMN Node Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNNodeInstanceImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNodeInstance()
	 * @generated
	 */
	int CMN_NODE_INSTANCE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__ID = Common_ConfigurationPackage.CFG_LOCATION__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__DESCRIPTION = Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__NAME = Common_ConfigurationPackage.CFG_LOCATION__NAME;

	/**
	 * The feature id for the '<em><b>Property Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__PROPERTY_GROUPS = Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__DEPLOYMENT = Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__TIMEZONE = Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE;

	/**
	 * The feature id for the '<em><b>Sub Locations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__SUB_LOCATIONS = Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__PARENT = Common_ConfigurationPackage.CFG_LOCATION__PARENT;

	/**
	 * The feature id for the '<em><b>Ref Sub Locations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__REF_SUB_LOCATIONS = Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Hostname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE__HOSTNAME = Common_ConfigurationPackage.CFG_LOCATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>CMN Node Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_NODE_INSTANCE_FEATURE_COUNT = Common_ConfigurationPackage.CFG_LOCATION_FEATURE_COUNT + 1;


	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNDefaultPropertyImpl <em>CMN Default Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNDefaultPropertyImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNDefaultProperty()
	 * @generated
	 */
	int CMN_DEFAULT_PROPERTY = 5;

	/**
	 * The number of structural features of the '<em>CMN Default Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_DEFAULT_PROPERTY_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNExtendedPropertyImpl <em>CMN Extended Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNExtendedPropertyImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNExtendedProperty()
	 * @generated
	 */
	int CMN_EXTENDED_PROPERTY = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_EXTENDED_PROPERTY__NAME = CMN_DEFAULT_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_EXTENDED_PROPERTY__TYPE = CMN_DEFAULT_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_EXTENDED_PROPERTY__VALUE = CMN_DEFAULT_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>CMN Extended Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_EXTENDED_PROPERTY_FEATURE_COUNT = CMN_DEFAULT_PROPERTY_FEATURE_COUNT + 3;


	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl <em>CMN Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl
	 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNAnnotation()
	 * @generated
	 */
	int CMN_ANNOTATION = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION__ID = CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION__DESCRIPTION = CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION__NAME = CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>URI</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION__URI = CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION__TYPE = CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>CMN Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CMN_ANNOTATION_FEATURE_COUNT = CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNNamedElement <em>CMN Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Named Element</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement
	 * @generated
	 */
	EClass getCMNNamedElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNNamedElement#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement#getId()
	 * @see #getCMNNamedElement()
	 * @generated
	 */
	EAttribute getCMNNamedElement_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNNamedElement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement#getName()
	 * @see #getCMNNamedElement()
	 * @generated
	 */
	EAttribute getCMNNamedElement_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNMachine <em>CMN Machine</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Machine</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNMachine
	 * @generated
	 */
	EClass getCMNMachine();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNNodeType <em>CMN Node Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Node Type</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNodeType
	 * @generated
	 */
	EClass getCMNNodeType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNNodeType#getHostname <em>Hostname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hostname</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNodeType#getHostname()
	 * @see #getCMNNodeType()
	 * @generated
	 */
	EAttribute getCMNNodeType_Hostname();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNNodeInstance <em>CMN Node Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Node Instance</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNodeInstance
	 * @generated
	 */
	EClass getCMNNodeInstance();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNNodeInstance#getHostname <em>Hostname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hostname</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNodeInstance#getHostname()
	 * @see #getCMNNodeInstance()
	 * @generated
	 */
	EAttribute getCMNNodeInstance_Hostname();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNExtendedProperty <em>CMN Extended Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Extended Property</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNExtendedProperty
	 * @generated
	 */
	EClass getCMNExtendedProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNExtendedProperty#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNExtendedProperty#getName()
	 * @see #getCMNExtendedProperty()
	 * @generated
	 */
	EAttribute getCMNExtendedProperty_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNExtendedProperty#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNExtendedProperty#getType()
	 * @see #getCMNExtendedProperty()
	 * @generated
	 */
	EAttribute getCMNExtendedProperty_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNExtendedProperty#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNExtendedProperty#getValue()
	 * @see #getCMNExtendedProperty()
	 * @generated
	 */
	EAttribute getCMNExtendedProperty_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNDefaultProperty <em>CMN Default Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Default Property</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNDefaultProperty
	 * @generated
	 */
	EClass getCMNDefaultProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.common.CMNAnnotation <em>CMN Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CMN Annotation</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNAnnotation
	 * @generated
	 */
	EClass getCMNAnnotation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNAnnotation#getURI <em>URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>URI</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNAnnotation#getURI()
	 * @see #getCMNAnnotation()
	 * @generated
	 */
	EAttribute getCMNAnnotation_URI();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNAnnotation#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNAnnotation#getType()
	 * @see #getCMNAnnotation()
	 * @generated
	 */
	EAttribute getCMNAnnotation_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.common.CMNNamedElement#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement#getDescription()
	 * @see #getCMNNamedElement()
	 * @generated
	 */
	EAttribute getCMNNamedElement_Description();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	CommonFactory getCommonFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals  {
		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl <em>CMN Named Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNamedElement()
		 * @generated
		 */
		EClass CMN_NAMED_ELEMENT = eINSTANCE.getCMNNamedElement();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_NAMED_ELEMENT__ID = eINSTANCE.getCMNNamedElement_Id();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_NAMED_ELEMENT__DESCRIPTION = eINSTANCE.getCMNNamedElement_Description();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_NAMED_ELEMENT__NAME = eINSTANCE.getCMNNamedElement_Name();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNMachineImpl <em>CMN Machine</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNMachineImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNMachine()
		 * @generated
		 */
		EClass CMN_MACHINE = eINSTANCE.getCMNMachine();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNodeTypeImpl <em>CMN Node Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNNodeTypeImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNodeType()
		 * @generated
		 */
		EClass CMN_NODE_TYPE = eINSTANCE.getCMNNodeType();

		/**
		 * The meta object literal for the '<em><b>Hostname</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_NODE_TYPE__HOSTNAME = eINSTANCE.getCMNNodeType_Hostname();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNNodeInstanceImpl <em>CMN Node Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNNodeInstanceImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNNodeInstance()
		 * @generated
		 */
		EClass CMN_NODE_INSTANCE = eINSTANCE.getCMNNodeInstance();

		/**
		 * The meta object literal for the '<em><b>Hostname</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_NODE_INSTANCE__HOSTNAME = eINSTANCE.getCMNNodeInstance_Hostname();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNExtendedPropertyImpl <em>CMN Extended Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNExtendedPropertyImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNExtendedProperty()
		 * @generated
		 */
		EClass CMN_EXTENDED_PROPERTY = eINSTANCE.getCMNExtendedProperty();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_EXTENDED_PROPERTY__NAME = eINSTANCE.getCMNExtendedProperty_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_EXTENDED_PROPERTY__TYPE = eINSTANCE.getCMNExtendedProperty_Type();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_EXTENDED_PROPERTY__VALUE = eINSTANCE.getCMNExtendedProperty_Value();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNDefaultPropertyImpl <em>CMN Default Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNDefaultPropertyImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNDefaultProperty()
		 * @generated
		 */
		EClass CMN_DEFAULT_PROPERTY = eINSTANCE.getCMNDefaultProperty();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl <em>CMN Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl
		 * @see org.eclipse.hyades.models.common.common.impl.CommonPackageImpl#getCMNAnnotation()
		 * @generated
		 */
		EClass CMN_ANNOTATION = eINSTANCE.getCMNAnnotation();

		/**
		 * The meta object literal for the '<em><b>URI</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_ANNOTATION__URI = eINSTANCE.getCMNAnnotation_URI();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CMN_ANNOTATION__TYPE = eINSTANCE.getCMNAnnotation_Type();

	}

} //CommonPackage
