/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CMNAnnotationImpl.java,v 1.14 2009/05/05 15:51:27 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.common.impl;

import java.io.IOException;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.facades.behavioral.IAnnotatableResource;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CMN Annotation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl#getURI <em>URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CMNAnnotationImpl extends CMNNamedElementImpl implements CMNAnnotation {
	/**
	 * The default value of the '{@link #getURI() <em>URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getURI()
	 * @generated
	 * @ordered
	 */
	protected static final String URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getURI() <em>URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getURI()
	 * @generated
	 * @ordered
	 */
	protected String uri = URI_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CMNAnnotationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CommonPackage.Literals.CMN_ANNOTATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getURI() {
		return uri;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setURI(String newURI) {
		String oldURI = uri;
		uri = newURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CommonPackage.CMN_ANNOTATION__URI, oldURI, uri));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CommonPackage.CMN_ANNOTATION__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CommonPackage.CMN_ANNOTATION__URI:
				return getURI();
			case CommonPackage.CMN_ANNOTATION__TYPE:
				return getType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CommonPackage.CMN_ANNOTATION__URI:
				setURI((String)newValue);
				return;
			case CommonPackage.CMN_ANNOTATION__TYPE:
				setType((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CommonPackage.CMN_ANNOTATION__URI:
				setURI(URI_EDEFAULT);
				return;
			case CommonPackage.CMN_ANNOTATION__TYPE:
				setType(TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CommonPackage.CMN_ANNOTATION__URI:
				return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT.equals(uri);
			case CommonPackage.CMN_ANNOTATION__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (URI: ");
		result.append(uri);
		result.append(", type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

	public static final String ANNOTATION_QUERY = "annotationID=/";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#getFileAnnotation()
	 */
	public URI getFileAnnotation() throws UnsupportedOperationException, IOException {
		if ( !isFileAnnotation() )
			throw new UnsupportedOperationException("Annotation is not a File Annotation " + toString());

		if ( !(this.eResource() instanceof IAnnotatableResource))
			throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
		
		return ((IAnnotatableResource)eResource()).getFileAnnotation(this);
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#isFileAnnotation()
	 */
	public boolean isFileAnnotation() {
		if ( !(this.eResource() instanceof IAnnotatableResource))
			throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
		
		return ((IAnnotatableResource)eResource()).isFileAnnotation(this);
		
	}
	
	/**
	 * @param uri2
	 */
	private URI queryURItoRelativeURI(URI uri) {
		
		if ( uri.hasQuery() )
		{
			String query = uri.query();
			String uriString = query.replaceFirst(ANNOTATION_QUERY, "");
			uri = URI.createURI(uriString);
		}
		return uri;
	}
	
	private URI relativeURItoQueryURI(URI uri) {
		
		if ( !uri.hasQuery() )
		{
			String queryString = ANNOTATION_QUERY + uri.toString();
			uri = URI.createHierarchicalURI(null, null, null, queryString, null);			
		}
		return uri;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#putFileAnnotation(org.eclipse.emf.common.util.URI)
	 */
	public void putFileAnnotation(URI file) throws UnsupportedOperationException, IOException {
		
		if ( !(this.eResource() instanceof IAnnotatableResource))
			throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
		
		((IAnnotatableResource)eResource()).putFileAnnotation(file, this);
	}

	/**
	 * @throws UnsupportedOperationException
	 */
	private String getContainerID() throws UnsupportedOperationException {
		String containerID;
		EObject container = this.eContainer();
		
		if ( container == null )
		{
			throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
		}
		
		if ( container instanceof CMNNamedElement )
		{
			CMNNamedElement con = (CMNNamedElement) container;
			containerID = con.getId();
		}
		else if ( container instanceof TPFExecutionEvent )
		{
			TPFExecutionEvent con = (TPFExecutionEvent) container;
			containerID = con.getId();
		}
		else
		{
			throw new UnsupportedOperationException("Annotations not supported for container of type " + container);
		}
		return containerID;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#removeFileAnnotation()
	 */
	public void removeFileAnnotation() throws UnsupportedOperationException, IOException {

		if ( !(this.eResource() instanceof IAnnotatableResource))
			throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
		try {
		((IAnnotatableResource)eResource()).removeFileAnnotation(this);
		} finally {
			setURI(URI_EDEFAULT);
		}
	}
} //CMNAnnotationImpl
