/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CFGInstance.java,v 1.7 2009/05/05 15:46:21 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CFG Instance</b></em>'.
 * @extends IVariable
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * CFGInstance repesents an instance variable of a CFGClass.  The objects represented by these instance variables are grouped in one or more artifacts.  The maxCount attribute of CFGInstance represents the maximum number of instances of the object represented by this instnace variable which will be created during a test execution.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline <em>Lifeline</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase <em>Test Case</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getMaxCount <em>Max Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getInitialValue <em>Initial Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner <em>Class Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType <em>Class Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance()
 * @model
 * @generated
 */
public interface CFGInstance extends CMNNamedElement, IVariable{
	/**
	 * Returns the value of the '<em><b>Max Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Max Count</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Max Count</em>' attribute.
	 * @see #setMaxCount(int)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_MaxCount()
	 * @model
	 * @generated
	 */
	int getMaxCount();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getMaxCount <em>Max Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max Count</em>' attribute.
	 * @see #getMaxCount()
	 * @generated
	 */
	void setMaxCount(int value);

	/**
	 * Returns the value of the '<em><b>Initial Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Initial Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Initial Value</em>' attribute.
	 * @see #setInitialValue(String)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_InitialValue()
	 * @model
	 * @generated
	 */
	String getInitialValue();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getInitialValue <em>Initial Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Initial Value</em>' attribute.
	 * @see #getInitialValue()
	 * @generated
	 */
	void setInitialValue(String value);

	/**
	 * Returns the value of the '<em><b>Lifeline</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lifeline</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lifeline</em>' reference.
	 * @see #setLifeline(BVRLifeline)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_Lifeline()
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInstances
	 * @model opposite="instances"
	 * @generated
	 */
	BVRLifeline getLifeline();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline <em>Lifeline</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lifeline</em>' reference.
	 * @see #getLifeline()
	 * @generated
	 */
	void setLifeline(BVRLifeline value);

	/**
	 * Returns the value of the '<em><b>Test Case</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTestCase#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Case</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Case</em>' container reference.
	 * @see #setTestCase(TPFTestCase)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_TestCase()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTestCase#getInstances
	 * @model opposite="instances"
	 * @generated
	 */
	TPFTestCase getTestCase();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase <em>Test Case</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Test Case</em>' container reference.
	 * @see #getTestCase()
	 * @generated
	 */
	void setTestCase(TPFTestCase value);

	/**
	 * Returns the value of the '<em><b>Class Owner</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Owner</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class Owner</em>' container reference.
	 * @see #setClassOwner(CFGClass)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_ClassOwner()
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getInstances
	 * @model opposite="instances"
	 * @generated
	 */
	CFGClass getClassOwner();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner <em>Class Owner</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class Owner</em>' container reference.
	 * @see #getClassOwner()
	 * @generated
	 */
	void setClassOwner(CFGClass value);

	/**
	 * Returns the value of the '<em><b>Class Type</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstantiations <em>Instantiations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class Type</em>' reference.
	 * @see #setClassType(CFGClass)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGInstance_ClassType()
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getInstantiations
	 * @model opposite="instantiations" required="true"
	 * @generated
	 */
	CFGClass getClassType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType <em>Class Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class Type</em>' reference.
	 * @see #getClassType()
	 * @generated
	 */
	void setClassType(CFGClass value);

} // CFGInstance
