/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CFGPropertyGroupImpl.java,v 1.11 2009/05/05 15:46:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Property Group</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getPropertyGroupID <em>Property Group ID</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getDefiningProperty <em>Defining Property</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGPropertyGroupImpl#getConfigurableObject <em>Configurable Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGPropertyGroupImpl extends CMNNamedElementImpl implements CFGPropertyGroup {
	/**
	 * The default value of the '{@link #getPropertyGroupID() <em>Property Group ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyGroupID()
	 * @generated
	 * @ordered
	 */
	protected static final String PROPERTY_GROUP_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPropertyGroupID() <em>Property Group ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPropertyGroupID()
	 * @generated
	 * @ordered
	 */
	protected String propertyGroupID = PROPERTY_GROUP_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGComparableProperty> properties;

	/**
	 * The cached value of the '{@link #getDefiningProperty() <em>Defining Property</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefiningProperty()
	 * @generated
	 * @ordered
	 */
	protected CFGComparableProperty definingProperty;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGPropertyGroupImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.Literals.CFG_PROPERTY_GROUP;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPropertyGroupID() {
		return propertyGroupID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPropertyGroupID(String newPropertyGroupID) {
		String oldPropertyGroupID = propertyGroupID;
		propertyGroupID = newPropertyGroupID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID, oldPropertyGroupID, propertyGroupID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGComparableProperty> getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList<CFGComparableProperty>(CFGComparableProperty.class, this, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGComparableProperty getDefiningProperty() {
		if (definingProperty != null && definingProperty.eIsProxy()) {
			InternalEObject oldDefiningProperty = (InternalEObject)definingProperty;
			definingProperty = (CFGComparableProperty)eResolveProxy(oldDefiningProperty);
			if (definingProperty != oldDefiningProperty) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
			}
		}
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGComparableProperty basicGetDefiningProperty() {
		return definingProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefiningProperty(CFGComparableProperty newDefiningProperty) {
		CFGComparableProperty oldDefiningProperty = definingProperty;
		definingProperty = newDefiningProperty;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY, oldDefiningProperty, definingProperty));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGConfigurableObject getConfigurableObject() {
		if (eContainerFeatureID() != Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT) return null;
		return (CFGConfigurableObject)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConfigurableObject(CFGConfigurableObject newConfigurableObject, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newConfigurableObject, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfigurableObject(CFGConfigurableObject newConfigurableObject) {
		if (newConfigurableObject != eInternalContainer() || (eContainerFeatureID() != Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT && newConfigurableObject != null)) {
			if (EcoreUtil.isAncestor(this, newConfigurableObject))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newConfigurableObject != null)
				msgs = ((InternalEObject)newConfigurableObject).eInverseAdd(this, Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS, CFGConfigurableObject.class, msgs);
			msgs = basicSetConfigurableObject(newConfigurableObject, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT, newConfigurableObject, newConfigurableObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetConfigurableObject((CFGConfigurableObject)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				return ((InternalEList<?>)getProperties()).basicRemove(otherEnd, msgs);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return basicSetConfigurableObject(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return eInternalContainer().eInverseRemove(this, Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT__PROPERTY_GROUPS, CFGConfigurableObject.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				return getPropertyGroupID();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				return getProperties();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				if (resolve) return getDefiningProperty();
				return basicGetDefiningProperty();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return getConfigurableObject();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				setPropertyGroupID((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection<? extends CFGComparableProperty>)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				setDefiningProperty((CFGComparableProperty)newValue);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				setConfigurableObject((CFGConfigurableObject)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				setPropertyGroupID(PROPERTY_GROUP_ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				getProperties().clear();
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				setDefiningProperty((CFGComparableProperty)null);
				return;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				setConfigurableObject((CFGConfigurableObject)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTY_GROUP_ID:
				return PROPERTY_GROUP_ID_EDEFAULT == null ? propertyGroupID != null : !PROPERTY_GROUP_ID_EDEFAULT.equals(propertyGroupID);
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__DEFINING_PROPERTY:
				return definingProperty != null;
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP__CONFIGURABLE_OBJECT:
				return getConfigurableObject() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (propertyGroupID: ");
		result.append(propertyGroupID);
		result.append(')');
		return result.toString();
	}

} //CFGPropertyGroupImpl
