/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Common_ConfigurationCategoryUtil.java,v 1.4 2006/02/08 19:56:52 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.configuration.util;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Common_ConfigurationCategoryUtil {

	public static final String DB_VER = "DB_VER"; //$NON-NLS-1$
	public static final String DB = "DB"; //$NON-NLS-1$
	public static final String DISP_DEPTH = "DISP_DEPTH"; //$NON-NLS-1$
	public static final String DISP_HEIGHT = "DISP_HEIGHT"; //$NON-NLS-1$
	public static final String DISP_WIDTH = "DISP_WIDTH"; //$NON-NLS-1$
	public static final String DISP_NUM	= "DISP_NUM"; //$NON-NLS-1$
	public static final String SVC_PAC = "SVC_PAC"; //$NON-NLS-1$
	public static final String WBR_TYPE	= "WBR_TYPE"; //$NON-NLS-1$
	public static final String WBR_VER = "WBR_VER"; //$NON-NLS-1$
	public static final String HNAME = "HNAME"; //$NON-NLS-1$
	public static final String WIN_DOM = "WIN_DOM"; //$NON-NLS-1$
	public static final String USR_NAME = "USR_NAME"; //$NON-NLS-1$
	public static final String MIN_VER = "MIN_VER"; //$NON-NLS-1$
	public static final String MAJ_VER = "MAJ_VER"; //$NON-NLS-1$
	public static final String OS = "OS"; //$NON-NLS-1$
	public static final String MEM_SZ = "MEM_SZ"; //$NON-NLS-1$
	public static final String PROC_TYPE = "PROC_TYPE"; //$NON-NLS-1$
	public static final String PROC_SPD	= "PROC_SPD"; //$NON-NLS-1$
	public static final String PROC_NUM	= "PROC_NUM"; //$NON-NLS-1$
	public static final String PASSWD = "PASSWD"; //$NON-NLS-1$
	public static final String CLSPATH = "CLASSPATH"; //$NON-NLS-1$
	public static final String ROOTDIR = "ROOTDIR"; //$NON-NLS-1$
	
	private ArrayList categories = null;
	private ArrayList categoryNames = null;
	private ArrayList categoryDisplayNames = null;
	private ArrayList enumerations = null;
	private HashMap nameCategoryMap = null;
	private HashMap categoryEnumerationMap = null;
	
	private static final Common_ConfigurationCategoryUtil instance = new Common_ConfigurationCategoryUtil();
	
	public static Common_ConfigurationCategoryUtil getInstance()
	{
		return instance;
	}
	
	protected Common_ConfigurationCategoryUtil()
	{
		categories = new ArrayList(100);
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserTypeCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserVersionCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseVersionCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayNumberCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesHostnameCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMajorVersionCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMemorySizeCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesMinorVersionCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorNumberCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorSpeedCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesUsernameCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesWindowsDomainCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesPasswordCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory());
		categories.add(Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory());
		
		enumerations = new ArrayList(100);
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesBrowserEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDatabaseEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayColorDepthEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayHeightEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesDisplayWidthEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesOperatingSystemEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesProcessorTypeEnumeration());
		enumerations.add(Common_ConfigurationFactory.eINSTANCE.createHyadesServicePackEnumeration());

		nameCategoryMap = new HashMap(100);
		categoryDisplayNames = new ArrayList(100);
		categoryNames = new ArrayList(100);
		for(int i = 0; i < categories.size(); i++)
		{
			ICategory category = (ICategory)categories.get(i);
			String name = category.getName();
			String displayName = category.getDisplayName();
			nameCategoryMap.put(name, category);
			categoryNames.add(name);
			categoryDisplayNames.add(displayName);
		}		

		categoryEnumerationMap = new HashMap(100);
		for(int i = 0; i < enumerations.size(); i++)
		{
			ICategoryEnumeration enumeration = (ICategoryEnumeration)enumerations.get(i);
			ICategory category = enumeration.getICategory();
			ArrayList enumerationList = new ArrayList(5);
			enumerationList.add(enumeration);
			if(category != null)
				categoryEnumerationMap.put(category.getName(), enumerationList);				
		}		
		
		addCategoriesFromExtensionPoint();
		addCategoryEnumerationsFromExtensionPoint();
	}

	private void addCategoriesFromExtensionPoint()
	{
		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.models.categoryExtensions");

		if (extensionPoint != null)
		{
			try {
      
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					ICategory category = (ICategory)extensionPoints[i].createExecutableExtension("categoryClass");
					if(nameCategoryMap.containsKey(category.getName()))
					{
						continue;
					}
					else
					{	
						if(category == null || category.getName() == null || category.getDisplayName() == null || nameCategoryMap.containsKey(category.getName()))
						{
							continue;
						}
						categories.add(category);
						categoryNames.add(category.getName());
						categoryDisplayNames.add(category.getDisplayName());
						nameCategoryMap.put(category.getName(), category);						
					}
				}
			}
			catch(Exception e)
			{
			}
		}	
	}
	
	private void addCategoryEnumerationsFromExtensionPoint()
	{
		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.models.categoryEnumerationExtensions");

		if (extensionPoint != null)
		{
			try {
      
				IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
				for(int i = 0; i < extensionPoints.length; i++)
				{
					ICategoryEnumeration enumeration = (ICategoryEnumeration)extensionPoints[i].createExecutableExtension("enumeration");
					if(enumeration == null || enumeration.getIEnumerationValues() == null)
					{
						continue;
					}
					ICategory category = enumeration.getICategory();
					if(category == null || !nameCategoryMap.containsKey(category.getName()))
					{
						continue;
					}					

					enumerations.add(enumeration);
					if(categoryEnumerationMap.containsKey(category.getName()))
					{
						ArrayList enumerationsList = (ArrayList)categoryEnumerationMap.get(category.getName());
						enumerationsList.add(enumeration);
					}
					else
					{
						ArrayList enumerationList = new ArrayList(5);
						enumerationList.add(enumeration);
						categoryEnumerationMap.put(category.getName(), enumerationList);
					}
				}
			}
			catch(Exception e)
			{
			}
		}	
		
	}

	public ICategory[] getCategories()
	{
		ICategory[] categories = new ICategory[this.categories.size()];
		for(int i = 0; i < this.categories.size(); i++)
		{
			categories[i] = (ICategory)this.categories.get(i);
		}
		return categories;
	}

	public ICategoryEnumeration[] getEnumerations()
	{
		ICategoryEnumeration[] enumerations = new ICategoryEnumeration[this.enumerations.size()];
		for(int i = 0; i < this.enumerations.size(); i++)
		{
			enumerations[i] = (ICategoryEnumeration)this.enumerations.get(i);
		}
		return enumerations;

	}

	public String[] getCategoryNames()
	{
		String[] names = new String[categoryNames.size()];
		for(int i = 0; i < categoryNames.size(); i++)
		{
			names[i] = (String)categoryNames.get(i);
		}
		return names;
	}
	
	public String[] getCategoryDisplayNames()
	{
		String[] displayNames = new String[categoryDisplayNames.size()];
		for(int i = 0; i < categoryDisplayNames.size(); i++)
		{
			displayNames[i] = (String)categoryDisplayNames.get(i);
		}
		return displayNames;
	}

	public ICategory getCategory(String categoryName)
	{
		return (ICategory)nameCategoryMap.get(categoryName);
	}
		
	public ICategoryEnumeration[] getCategoryEnumeration(ICategory category)
	{
		if(category == null)
			return null;
		ArrayList enumerationList = (ArrayList)categoryEnumerationMap.get(category.getName());
		if(enumerationList == null)
			return null;
		ICategoryEnumeration[] returnArray = new ICategoryEnumeration[enumerationList.size()];
		for(int i = 0; i < enumerationList.size(); i++)
		{
			returnArray[i] = (ICategoryEnumeration)enumerationList.get(i);
		}
		return returnArray;
	}

	public ICategoryEnumeration[] getCategoryEnumeration(String categoryName)
	{
		ICategory category = null;
		if(nameCategoryMap != null)
			category = (ICategory)nameCategoryMap.get(categoryName);
		return getCategoryEnumeration(category);
	}
}
