/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_ConfigurationSwitch.java,v 1.12 2009/05/05 15:51:28 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CMNNodeInstance;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGMachineInstance;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.CFGPsudoEnumeration;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserTypeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesBrowserVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesClasspathCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDatabaseVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayColorDepthCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayColorDepthEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayHeightCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayHeightEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayNumberCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayWidthCategory;
import org.eclipse.hyades.models.common.configuration.HyadesDisplayWidthEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesHostnameCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMajorVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMemorySizeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesMinorVersionCategory;
import org.eclipse.hyades.models.common.configuration.HyadesOperatingSystemCategory;
import org.eclipse.hyades.models.common.configuration.HyadesOperatingSystemEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesPasswordCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorNumberCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorSpeedCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorTypeCategory;
import org.eclipse.hyades.models.common.configuration.HyadesProcessorTypeEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesRootDirectroyCategory;
import org.eclipse.hyades.models.common.configuration.HyadesServicePackCategory;
import org.eclipse.hyades.models.common.configuration.HyadesServicePackEnumeration;
import org.eclipse.hyades.models.common.configuration.HyadesUsernameCategory;
import org.eclipse.hyades.models.common.configuration.HyadesWindowsDomainCategory;
import org.eclipse.hyades.models.common.interactions.BVRProperty;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage
 * @generated
 */
public class Common_ConfigurationSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_ConfigurationPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_ConfigurationSwitch() {
		if (modelPackage == null) {
			modelPackage = Common_ConfigurationPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case Common_ConfigurationPackage.CFG_LOCATION: {
				CFGLocation cfgLocation = (CFGLocation)theEObject;
				T result = caseCFGLocation(cfgLocation);
				if (result == null) result = caseCFGConfigurableObject(cfgLocation);
				if (result == null) result = caseCMNNamedElement(cfgLocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_CLASS: {
				CFGClass cfgClass = (CFGClass)theEObject;
				T result = caseCFGClass(cfgClass);
				if (result == null) result = caseCMNNamedElement(cfgClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_OPERATION: {
				CFGOperation cfgOperation = (CFGOperation)theEObject;
				T result = caseCFGOperation(cfgOperation);
				if (result == null) result = caseCMNNamedElement(cfgOperation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_ARTIFACT: {
				CFGArtifact cfgArtifact = (CFGArtifact)theEObject;
				T result = caseCFGArtifact(cfgArtifact);
				if (result == null) result = caseCFGConfigurableObject(cfgArtifact);
				if (result == null) result = caseCMNNamedElement(cfgArtifact);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_INSTANCE: {
				CFGInstance cfgInstance = (CFGInstance)theEObject;
				T result = caseCFGInstance(cfgInstance);
				if (result == null) result = caseCMNNamedElement(cfgInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_COMPARABLE_PROPERTY: {
				CFGComparableProperty cfgComparableProperty = (CFGComparableProperty)theEObject;
				T result = caseCFGComparableProperty(cfgComparableProperty);
				if (result == null) result = caseBVRProperty(cfgComparableProperty);
				if (result == null) result = caseCMNNamedElement(cfgComparableProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_PROPERTY_GROUP: {
				CFGPropertyGroup cfgPropertyGroup = (CFGPropertyGroup)theEObject;
				T result = caseCFGPropertyGroup(cfgPropertyGroup);
				if (result == null) result = caseCMNNamedElement(cfgPropertyGroup);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_CATEGORY: {
				CFGCategory cfgCategory = (CFGCategory)theEObject;
				T result = caseCFGCategory(cfgCategory);
				if (result == null) result = caseCMNNamedElement(cfgCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_OPERATING_SYSTEM_ENUMERATION: {
				HyadesOperatingSystemEnumeration hyadesOperatingSystemEnumeration = (HyadesOperatingSystemEnumeration)theEObject;
				T result = caseHyadesOperatingSystemEnumeration(hyadesOperatingSystemEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesOperatingSystemEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_OPERATING_SYSTEM_CATEGORY: {
				HyadesOperatingSystemCategory hyadesOperatingSystemCategory = (HyadesOperatingSystemCategory)theEObject;
				T result = caseHyadesOperatingSystemCategory(hyadesOperatingSystemCategory);
				if (result == null) result = caseCFGCategory(hyadesOperatingSystemCategory);
				if (result == null) result = caseCMNNamedElement(hyadesOperatingSystemCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_PROCESSOR_TYPE_CATEGORY: {
				HyadesProcessorTypeCategory hyadesProcessorTypeCategory = (HyadesProcessorTypeCategory)theEObject;
				T result = caseHyadesProcessorTypeCategory(hyadesProcessorTypeCategory);
				if (result == null) result = caseCFGCategory(hyadesProcessorTypeCategory);
				if (result == null) result = caseCMNNamedElement(hyadesProcessorTypeCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_MEMORY_SIZE_CATEGORY: {
				HyadesMemorySizeCategory hyadesMemorySizeCategory = (HyadesMemorySizeCategory)theEObject;
				T result = caseHyadesMemorySizeCategory(hyadesMemorySizeCategory);
				if (result == null) result = caseCFGCategory(hyadesMemorySizeCategory);
				if (result == null) result = caseCMNNamedElement(hyadesMemorySizeCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_PROCESSOR_SPEED_CATEGORY: {
				HyadesProcessorSpeedCategory hyadesProcessorSpeedCategory = (HyadesProcessorSpeedCategory)theEObject;
				T result = caseHyadesProcessorSpeedCategory(hyadesProcessorSpeedCategory);
				if (result == null) result = caseCFGCategory(hyadesProcessorSpeedCategory);
				if (result == null) result = caseCMNNamedElement(hyadesProcessorSpeedCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_PROCESSOR_TYPE_ENUMERATION: {
				HyadesProcessorTypeEnumeration hyadesProcessorTypeEnumeration = (HyadesProcessorTypeEnumeration)theEObject;
				T result = caseHyadesProcessorTypeEnumeration(hyadesProcessorTypeEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesProcessorTypeEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_BROWSER_TYPE_CATEGORY: {
				HyadesBrowserTypeCategory hyadesBrowserTypeCategory = (HyadesBrowserTypeCategory)theEObject;
				T result = caseHyadesBrowserTypeCategory(hyadesBrowserTypeCategory);
				if (result == null) result = caseCFGCategory(hyadesBrowserTypeCategory);
				if (result == null) result = caseCMNNamedElement(hyadesBrowserTypeCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_BROWSER_VERSION_CATEGORY: {
				HyadesBrowserVersionCategory hyadesBrowserVersionCategory = (HyadesBrowserVersionCategory)theEObject;
				T result = caseHyadesBrowserVersionCategory(hyadesBrowserVersionCategory);
				if (result == null) result = caseCFGCategory(hyadesBrowserVersionCategory);
				if (result == null) result = caseCMNNamedElement(hyadesBrowserVersionCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_BROWSER_ENUMERATION: {
				HyadesBrowserEnumeration hyadesBrowserEnumeration = (HyadesBrowserEnumeration)theEObject;
				T result = caseHyadesBrowserEnumeration(hyadesBrowserEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesBrowserEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_PROCESSOR_NUMBER_CATEGORY: {
				HyadesProcessorNumberCategory hyadesProcessorNumberCategory = (HyadesProcessorNumberCategory)theEObject;
				T result = caseHyadesProcessorNumberCategory(hyadesProcessorNumberCategory);
				if (result == null) result = caseCFGCategory(hyadesProcessorNumberCategory);
				if (result == null) result = caseCMNNamedElement(hyadesProcessorNumberCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_COLOR_DEPTH_CATEGORY: {
				HyadesDisplayColorDepthCategory hyadesDisplayColorDepthCategory = (HyadesDisplayColorDepthCategory)theEObject;
				T result = caseHyadesDisplayColorDepthCategory(hyadesDisplayColorDepthCategory);
				if (result == null) result = caseCFGCategory(hyadesDisplayColorDepthCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDisplayColorDepthCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_COLOR_DEPTH_ENUMERATION: {
				HyadesDisplayColorDepthEnumeration hyadesDisplayColorDepthEnumeration = (HyadesDisplayColorDepthEnumeration)theEObject;
				T result = caseHyadesDisplayColorDepthEnumeration(hyadesDisplayColorDepthEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayColorDepthEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_HEIGHT_CATEGORY: {
				HyadesDisplayHeightCategory hyadesDisplayHeightCategory = (HyadesDisplayHeightCategory)theEObject;
				T result = caseHyadesDisplayHeightCategory(hyadesDisplayHeightCategory);
				if (result == null) result = caseCFGCategory(hyadesDisplayHeightCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDisplayHeightCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_CATEGORY: {
				HyadesDisplayWidthCategory hyadesDisplayWidthCategory = (HyadesDisplayWidthCategory)theEObject;
				T result = caseHyadesDisplayWidthCategory(hyadesDisplayWidthCategory);
				if (result == null) result = caseCFGCategory(hyadesDisplayWidthCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDisplayWidthCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_HEIGHT_ENUMERATION: {
				HyadesDisplayHeightEnumeration hyadesDisplayHeightEnumeration = (HyadesDisplayHeightEnumeration)theEObject;
				T result = caseHyadesDisplayHeightEnumeration(hyadesDisplayHeightEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayHeightEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_WIDTH_ENUMERATION: {
				HyadesDisplayWidthEnumeration hyadesDisplayWidthEnumeration = (HyadesDisplayWidthEnumeration)theEObject;
				T result = caseHyadesDisplayWidthEnumeration(hyadesDisplayWidthEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesDisplayWidthEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DISPLAY_NUMBER_CATEGORY: {
				HyadesDisplayNumberCategory hyadesDisplayNumberCategory = (HyadesDisplayNumberCategory)theEObject;
				T result = caseHyadesDisplayNumberCategory(hyadesDisplayNumberCategory);
				if (result == null) result = caseCFGCategory(hyadesDisplayNumberCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDisplayNumberCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DATABASE_CATEGORY: {
				HyadesDatabaseCategory hyadesDatabaseCategory = (HyadesDatabaseCategory)theEObject;
				T result = caseHyadesDatabaseCategory(hyadesDatabaseCategory);
				if (result == null) result = caseCFGCategory(hyadesDatabaseCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDatabaseCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DATABASE_VERSION_CATEGORY: {
				HyadesDatabaseVersionCategory hyadesDatabaseVersionCategory = (HyadesDatabaseVersionCategory)theEObject;
				T result = caseHyadesDatabaseVersionCategory(hyadesDatabaseVersionCategory);
				if (result == null) result = caseCFGCategory(hyadesDatabaseVersionCategory);
				if (result == null) result = caseCMNNamedElement(hyadesDatabaseVersionCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_DATABASE_ENUMERATION: {
				HyadesDatabaseEnumeration hyadesDatabaseEnumeration = (HyadesDatabaseEnumeration)theEObject;
				T result = caseHyadesDatabaseEnumeration(hyadesDatabaseEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesDatabaseEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_MACHINE_INSTANCE: {
				CFGMachineInstance cfgMachineInstance = (CFGMachineInstance)theEObject;
				T result = caseCFGMachineInstance(cfgMachineInstance);
				if (result == null) result = caseCMNNodeInstance(cfgMachineInstance);
				if (result == null) result = caseCFGLocation(cfgMachineInstance);
				if (result == null) result = caseCFGConfigurableObject(cfgMachineInstance);
				if (result == null) result = caseCMNNamedElement(cfgMachineInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_MACHINE_CONSTRAINT: {
				CFGMachineConstraint cfgMachineConstraint = (CFGMachineConstraint)theEObject;
				T result = caseCFGMachineConstraint(cfgMachineConstraint);
				if (result == null) result = caseCMNNodeType(cfgMachineConstraint);
				if (result == null) result = caseCFGLocation(cfgMachineConstraint);
				if (result == null) result = caseCFGConfigurableObject(cfgMachineConstraint);
				if (result == null) result = caseCMNNamedElement(cfgMachineConstraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_CONFIGURABLE_OBJECT: {
				CFGConfigurableObject cfgConfigurableObject = (CFGConfigurableObject)theEObject;
				T result = caseCFGConfigurableObject(cfgConfigurableObject);
				if (result == null) result = caseCMNNamedElement(cfgConfigurableObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_HOSTNAME_CATEGORY: {
				HyadesHostnameCategory hyadesHostnameCategory = (HyadesHostnameCategory)theEObject;
				T result = caseHyadesHostnameCategory(hyadesHostnameCategory);
				if (result == null) result = caseCFGCategory(hyadesHostnameCategory);
				if (result == null) result = caseCMNNamedElement(hyadesHostnameCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_WINDOWS_DOMAIN_CATEGORY: {
				HyadesWindowsDomainCategory hyadesWindowsDomainCategory = (HyadesWindowsDomainCategory)theEObject;
				T result = caseHyadesWindowsDomainCategory(hyadesWindowsDomainCategory);
				if (result == null) result = caseCFGCategory(hyadesWindowsDomainCategory);
				if (result == null) result = caseCMNNamedElement(hyadesWindowsDomainCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_USERNAME_CATEGORY: {
				HyadesUsernameCategory hyadesUsernameCategory = (HyadesUsernameCategory)theEObject;
				T result = caseHyadesUsernameCategory(hyadesUsernameCategory);
				if (result == null) result = caseCFGCategory(hyadesUsernameCategory);
				if (result == null) result = caseCMNNamedElement(hyadesUsernameCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_SERVICE_PACK_CATEGORY: {
				HyadesServicePackCategory hyadesServicePackCategory = (HyadesServicePackCategory)theEObject;
				T result = caseHyadesServicePackCategory(hyadesServicePackCategory);
				if (result == null) result = caseCFGCategory(hyadesServicePackCategory);
				if (result == null) result = caseCMNNamedElement(hyadesServicePackCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_MAJOR_VERSION_CATEGORY: {
				HyadesMajorVersionCategory hyadesMajorVersionCategory = (HyadesMajorVersionCategory)theEObject;
				T result = caseHyadesMajorVersionCategory(hyadesMajorVersionCategory);
				if (result == null) result = caseCFGCategory(hyadesMajorVersionCategory);
				if (result == null) result = caseCMNNamedElement(hyadesMajorVersionCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_MINOR_VERSION_CATEGORY: {
				HyadesMinorVersionCategory hyadesMinorVersionCategory = (HyadesMinorVersionCategory)theEObject;
				T result = caseHyadesMinorVersionCategory(hyadesMinorVersionCategory);
				if (result == null) result = caseCFGCategory(hyadesMinorVersionCategory);
				if (result == null) result = caseCMNNamedElement(hyadesMinorVersionCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_SERVICE_PACK_ENUMERATION: {
				HyadesServicePackEnumeration hyadesServicePackEnumeration = (HyadesServicePackEnumeration)theEObject;
				T result = caseHyadesServicePackEnumeration(hyadesServicePackEnumeration);
				if (result == null) result = caseCFGPsudoEnumeration(hyadesServicePackEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_ARTIFACT_LOCATION_PAIR: {
				CFGArtifactLocationPair cfgArtifactLocationPair = (CFGArtifactLocationPair)theEObject;
				T result = caseCFGArtifactLocationPair(cfgArtifactLocationPair);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_MACHINE: {
				CFGMachine cfgMachine = (CFGMachine)theEObject;
				T result = caseCFGMachine(cfgMachine);
				if (result == null) result = caseCFGLocation(cfgMachine);
				if (result == null) result = caseCFGConfigurableObject(cfgMachine);
				if (result == null) result = caseCMNNamedElement(cfgMachine);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.CFG_PSUDO_ENUMERATION: {
				CFGPsudoEnumeration cfgPsudoEnumeration = (CFGPsudoEnumeration)theEObject;
				T result = caseCFGPsudoEnumeration(cfgPsudoEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_PASSWORD_CATEGORY: {
				HyadesPasswordCategory hyadesPasswordCategory = (HyadesPasswordCategory)theEObject;
				T result = caseHyadesPasswordCategory(hyadesPasswordCategory);
				if (result == null) result = caseCFGCategory(hyadesPasswordCategory);
				if (result == null) result = caseCMNNamedElement(hyadesPasswordCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_CLASSPATH_CATEGORY: {
				HyadesClasspathCategory hyadesClasspathCategory = (HyadesClasspathCategory)theEObject;
				T result = caseHyadesClasspathCategory(hyadesClasspathCategory);
				if (result == null) result = caseCFGCategory(hyadesClasspathCategory);
				if (result == null) result = caseCMNNamedElement(hyadesClasspathCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_ConfigurationPackage.HYADES_ROOT_DIRECTROY_CATEGORY: {
				HyadesRootDirectroyCategory hyadesRootDirectroyCategory = (HyadesRootDirectroyCategory)theEObject;
				T result = caseHyadesRootDirectroyCategory(hyadesRootDirectroyCategory);
				if (result == null) result = caseCFGCategory(hyadesRootDirectroyCategory);
				if (result == null) result = caseCMNNamedElement(hyadesRootDirectroyCategory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Location</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Location</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGLocation(CFGLocation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGClass(CFGClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Operation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGOperation(CFGOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Artifact</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Artifact</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGArtifact(CFGArtifact object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGInstance(CFGInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Comparable Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Comparable Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGComparableProperty(CFGComparableProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Property Group</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Property Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGPropertyGroup(CFGPropertyGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGCategory(CFGCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Operating System Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Operating System Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesOperatingSystemEnumeration(HyadesOperatingSystemEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Operating System Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Operating System Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesOperatingSystemCategory(HyadesOperatingSystemCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Processor Type Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Processor Type Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesProcessorTypeCategory(HyadesProcessorTypeCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Memory Size Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Memory Size Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesMemorySizeCategory(HyadesMemorySizeCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Processor Speed Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Processor Speed Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesProcessorSpeedCategory(HyadesProcessorSpeedCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Processor Type Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Processor Type Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesProcessorTypeEnumeration(HyadesProcessorTypeEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Browser Type Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Browser Type Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesBrowserTypeCategory(HyadesBrowserTypeCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Browser Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Browser Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesBrowserVersionCategory(HyadesBrowserVersionCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Browser Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Browser Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesBrowserEnumeration(HyadesBrowserEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Processor Number Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Processor Number Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesProcessorNumberCategory(HyadesProcessorNumberCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Color Depth Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Color Depth Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayColorDepthCategory(HyadesDisplayColorDepthCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Color Depth Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Color Depth Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayColorDepthEnumeration(HyadesDisplayColorDepthEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Height Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Height Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayHeightCategory(HyadesDisplayHeightCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Width Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Width Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayWidthCategory(HyadesDisplayWidthCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Height Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Height Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayHeightEnumeration(HyadesDisplayHeightEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Width Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Width Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayWidthEnumeration(HyadesDisplayWidthEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Display Number Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Display Number Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDisplayNumberCategory(HyadesDisplayNumberCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Database Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Database Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDatabaseCategory(HyadesDatabaseCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Database Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Database Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDatabaseVersionCategory(HyadesDatabaseVersionCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Database Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Database Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesDatabaseEnumeration(HyadesDatabaseEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Machine Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Machine Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGMachineInstance(CFGMachineInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Machine Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Machine Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGMachineConstraint(CFGMachineConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGConfigurableObject(CFGConfigurableObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Hostname Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Hostname Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesHostnameCategory(HyadesHostnameCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Windows Domain Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Windows Domain Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesWindowsDomainCategory(HyadesWindowsDomainCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Username Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Username Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesUsernameCategory(HyadesUsernameCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Service Pack Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Service Pack Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesServicePackCategory(HyadesServicePackCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Major Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Major Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesMajorVersionCategory(HyadesMajorVersionCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Minor Version Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Minor Version Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesMinorVersionCategory(HyadesMinorVersionCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Service Pack Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Service Pack Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesServicePackEnumeration(HyadesServicePackEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Artifact Location Pair</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Artifact Location Pair</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGArtifactLocationPair(CFGArtifactLocationPair object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Machine</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Machine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGMachine(CFGMachine object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Psudo Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Psudo Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGPsudoEnumeration(CFGPsudoEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Password Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Password Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesPasswordCategory(HyadesPasswordCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Classpath Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Classpath Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesClasspathCategory(HyadesClasspathCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hyades Root Directroy Category</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hyades Root Directroy Category</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHyadesRootDirectroyCategory(HyadesRootDirectroyCategory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CMN Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CMN Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCMNNamedElement(CMNNamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>BVR Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>BVR Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBVRProperty(BVRProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CMN Node Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CMN Node Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCMNNodeInstance(CMNNodeInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CMN Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CMN Node Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCMNNodeType(CMNNodeType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //Common_ConfigurationSwitch
