/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_DatapoolPackage.java,v 1.10 2009/05/05 15:46:22 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.datapool;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory
 * @model kind="package"
 * @generated
 */
public interface Common_DatapoolPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "datapool";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/common/datapool.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Common_Datapool";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Common_DatapoolPackage eINSTANCE = org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl <em>DPL Datapool Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLDatapoolSpec()
	 * @generated
	 */
	int DPL_DATAPOOL_SPEC = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_SPEC__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_SPEC__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_SPEC__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_SPEC__VARIABLES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>DPL Datapool Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_SPEC_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl <em>DPL Datapool</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLDatapool()
	 * @generated
	 */
	int DPL_DATAPOOL = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl <em>DPL Equivalence Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLEquivalenceClass()
	 * @generated
	 */
	int DPL_EQUIVALENCE_CLASS = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_EQUIVALENCE_CLASS__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_EQUIVALENCE_CLASS__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_EQUIVALENCE_CLASS__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Records</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_EQUIVALENCE_CLASS__RECORDS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>DPL Equivalence Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_EQUIVALENCE_CLASS_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl <em>DPL Record</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLRecord()
	 * @generated
	 */
	int DPL_RECORD = 2;

	/**
	 * The feature id for the '<em><b>Datapool</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_RECORD__DATAPOOL = 0;

	/**
	 * The feature id for the '<em><b>Cells</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_RECORD__CELLS = 1;

	/**
	 * The number of structural features of the '<em>DPL Record</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_RECORD_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl <em>DPL Cell</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLCell()
	 * @generated
	 */
	int DPL_CELL = 3;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_CELL__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Variable</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_CELL__VARIABLE = 1;

	/**
	 * The number of structural features of the '<em>DPL Cell</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_CELL_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl <em>DPL Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLVariable()
	 * @generated
	 */
	int DPL_VARIABLE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__TYPE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__ROLE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Encrypted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__ENCRYPTED = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE__VARIABLES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>DPL Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_VARIABLE_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__ID = Common_ConfigurationPackage.CFG_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__DESCRIPTION = Common_ConfigurationPackage.CFG_CLASS__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__NAME = Common_ConfigurationPackage.CFG_CLASS__NAME;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__OPERATIONS = Common_ConfigurationPackage.CFG_CLASS__OPERATIONS;

	/**
	 * The feature id for the '<em><b>Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__INSTANCES = Common_ConfigurationPackage.CFG_CLASS__INSTANCES;

	/**
	 * The feature id for the '<em><b>Instantiations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__INSTANTIATIONS = Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS;

	/**
	 * The feature id for the '<em><b>Challenge</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__CHALLENGE = Common_ConfigurationPackage.CFG_CLASS_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Equivalence Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__EQUIVALENCE_CLASSES = Common_ConfigurationPackage.CFG_CLASS_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Datapool Spec</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL__DATAPOOL_SPEC = Common_ConfigurationPackage.CFG_CLASS_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>DPL Datapool</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DPL_DATAPOOL_FEATURE_COUNT = Common_ConfigurationPackage.CFG_CLASS_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.datapool.DPLRole <em>DPL Role</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.datapool.DPLRole
	 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLRole()
	 * @generated
	 */
	int DPL_ROLE = 6;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec <em>DPL Datapool Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Datapool Spec</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec
	 * @generated
	 */
	EClass getDPLDatapoolSpec();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec#getVariables <em>Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variables</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec#getVariables()
	 * @see #getDPLDatapoolSpec()
	 * @generated
	 */
	EReference getDPLDatapoolSpec_Variables();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool <em>DPL Datapool</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Datapool</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapool
	 * @generated
	 */
	EClass getDPLDatapool();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getChallenge <em>Challenge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Challenge</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapool#getChallenge()
	 * @see #getDPLDatapool()
	 * @generated
	 */
	EAttribute getDPLDatapool_Challenge();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getEquivalenceClasses <em>Equivalence Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Equivalence Classes</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapool#getEquivalenceClasses()
	 * @see #getDPLDatapool()
	 * @generated
	 */
	EReference getDPLDatapool_EquivalenceClasses();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getDatapoolSpec <em>Datapool Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Datapool Spec</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapool#getDatapoolSpec()
	 * @see #getDPLDatapool()
	 * @generated
	 */
	EReference getDPLDatapool_DatapoolSpec();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass <em>DPL Equivalence Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Equivalence Class</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass
	 * @generated
	 */
	EClass getDPLEquivalenceClass();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass#getRecords <em>Records</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Records</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass#getRecords()
	 * @see #getDPLEquivalenceClass()
	 * @generated
	 */
	EReference getDPLEquivalenceClass_Records();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLRecord <em>DPL Record</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Record</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLRecord
	 * @generated
	 */
	EClass getDPLRecord();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.datapool.DPLRecord#getDatapool <em>Datapool</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Datapool</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLRecord#getDatapool()
	 * @see #getDPLRecord()
	 * @generated
	 */
	EReference getDPLRecord_Datapool();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.datapool.DPLRecord#getCells <em>Cells</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Cells</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLRecord#getCells()
	 * @see #getDPLRecord()
	 * @generated
	 */
	EReference getDPLRecord_Cells();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLCell <em>DPL Cell</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Cell</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLCell
	 * @generated
	 */
	EClass getDPLCell();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.datapool.DPLCell#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLCell#getValue()
	 * @see #getDPLCell()
	 * @generated
	 */
	EAttribute getDPLCell_Value();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.datapool.DPLCell#getVariable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Variable</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLCell#getVariable()
	 * @see #getDPLCell()
	 * @generated
	 */
	EReference getDPLCell_Variable();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.datapool.DPLVariable <em>DPL Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DPL Variable</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable
	 * @generated
	 */
	EClass getDPLVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.datapool.DPLVariable#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable#getType()
	 * @see #getDPLVariable()
	 * @generated
	 */
	EAttribute getDPLVariable_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.datapool.DPLVariable#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable#getRole()
	 * @see #getDPLVariable()
	 * @generated
	 */
	EAttribute getDPLVariable_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.datapool.DPLVariable#isEncrypted <em>Encrypted</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Encrypted</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable#isEncrypted()
	 * @see #getDPLVariable()
	 * @generated
	 */
	EAttribute getDPLVariable_Encrypted();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.datapool.DPLVariable#getVariables <em>Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Variables</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable#getVariables()
	 * @see #getDPLVariable()
	 * @generated
	 */
	EReference getDPLVariable_Variables();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.common.datapool.DPLRole <em>DPL Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>DPL Role</em>'.
	 * @see org.eclipse.hyades.models.common.datapool.DPLRole
	 * @generated
	 */
	EEnum getDPLRole();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	Common_DatapoolFactory getCommon_DatapoolFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals  {
		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl <em>DPL Datapool Spec</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLDatapoolSpec()
		 * @generated
		 */
		EClass DPL_DATAPOOL_SPEC = eINSTANCE.getDPLDatapoolSpec();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_DATAPOOL_SPEC__VARIABLES = eINSTANCE.getDPLDatapoolSpec_Variables();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl <em>DPL Equivalence Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLEquivalenceClass()
		 * @generated
		 */
		EClass DPL_EQUIVALENCE_CLASS = eINSTANCE.getDPLEquivalenceClass();

		/**
		 * The meta object literal for the '<em><b>Records</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_EQUIVALENCE_CLASS__RECORDS = eINSTANCE.getDPLEquivalenceClass_Records();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl <em>DPL Record</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLRecord()
		 * @generated
		 */
		EClass DPL_RECORD = eINSTANCE.getDPLRecord();

		/**
		 * The meta object literal for the '<em><b>Datapool</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_RECORD__DATAPOOL = eINSTANCE.getDPLRecord_Datapool();

		/**
		 * The meta object literal for the '<em><b>Cells</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_RECORD__CELLS = eINSTANCE.getDPLRecord_Cells();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl <em>DPL Cell</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLCell()
		 * @generated
		 */
		EClass DPL_CELL = eINSTANCE.getDPLCell();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DPL_CELL__VALUE = eINSTANCE.getDPLCell_Value();

		/**
		 * The meta object literal for the '<em><b>Variable</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_CELL__VARIABLE = eINSTANCE.getDPLCell_Variable();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl <em>DPL Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLVariable()
		 * @generated
		 */
		EClass DPL_VARIABLE = eINSTANCE.getDPLVariable();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DPL_VARIABLE__TYPE = eINSTANCE.getDPLVariable_Type();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DPL_VARIABLE__ROLE = eINSTANCE.getDPLVariable_Role();

		/**
		 * The meta object literal for the '<em><b>Encrypted</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DPL_VARIABLE__ENCRYPTED = eINSTANCE.getDPLVariable_Encrypted();

		/**
		 * The meta object literal for the '<em><b>Variables</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_VARIABLE__VARIABLES = eINSTANCE.getDPLVariable_Variables();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl <em>DPL Datapool</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLDatapool()
		 * @generated
		 */
		EClass DPL_DATAPOOL = eINSTANCE.getDPLDatapool();

		/**
		 * The meta object literal for the '<em><b>Challenge</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DPL_DATAPOOL__CHALLENGE = eINSTANCE.getDPLDatapool_Challenge();

		/**
		 * The meta object literal for the '<em><b>Equivalence Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_DATAPOOL__EQUIVALENCE_CLASSES = eINSTANCE.getDPLDatapool_EquivalenceClasses();

		/**
		 * The meta object literal for the '<em><b>Datapool Spec</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DPL_DATAPOOL__DATAPOOL_SPEC = eINSTANCE.getDPLDatapool_DatapoolSpec();

		/**
		 * The meta object literal for the '{@link org.eclipse.hyades.models.common.datapool.DPLRole <em>DPL Role</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.hyades.models.common.datapool.DPLRole
		 * @see org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolPackageImpl#getDPLRole()
		 * @generated
		 */
		EEnum DPL_ROLE = eINSTANCE.getDPLRole();

	}

} //Common_DatapoolPackage
