/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: DPLDatapool.java,v 1.10 2009/05/05 15:46:22 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.datapool;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>DPL Datapool</b></em>'.
 * @extends IDatapool
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getChallenge <em>Challenge</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getEquivalenceClasses <em>Equivalence Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getDatapoolSpec <em>Datapool Spec</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage#getDPLDatapool()
 * @model
 * @generated
 */
public interface DPLDatapool extends CFGClass, CMNNamedElement, IDatapool {
	/**
	 * Returns the value of the '<em><b>Challenge</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * This string is used to determine whether a user supplied password for an encrypted datapool is correct.
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Challenge</em>' attribute.
	 * @see #setChallenge(String)
	 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage#getDPLDatapool_Challenge()
	 * @model
	 * @generated
	 */
	String getChallenge();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getChallenge <em>Challenge</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * This string is used to determine whether a user supplied password for an encrypted datapool is correct.
	 * </p>
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Challenge</em>' attribute.
	 * @see #getChallenge()
	 * @generated
	 */
	void setChallenge(String value);

	/**
	 * Returns the value of the '<em><b>Equivalence Classes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Equivalence Classes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Equivalence Classes</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage#getDPLDatapool_EquivalenceClasses()
	 * @model containment="true"
	 * @generated
	 */
	EList<DPLEquivalenceClass> getEquivalenceClasses();

	/**
	 * Returns the value of the '<em><b>Datapool Spec</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Datapool Spec</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Datapool Spec</em>' containment reference.
	 * @see #setDatapoolSpec(DPLDatapoolSpec)
	 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage#getDPLDatapool_DatapoolSpec()
	 * @model containment="true" required="true"
	 * @generated
	 */
	DPLDatapoolSpec getDatapoolSpec();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool#getDatapoolSpec <em>Datapool Spec</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Datapool Spec</em>' containment reference.
	 * @see #getDatapoolSpec()
	 * @generated
	 */
	void setDatapoolSpec(DPLDatapoolSpec value);

	
} // DPLDatapool
