/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_DatapoolFactoryImpl.java,v 1.15 2009/05/05 15:51:28 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collections;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class Common_DatapoolFactoryImpl extends EFactoryImpl 
              implements Common_DatapoolFactory {
              	
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Common_DatapoolFactory init() {
		try {
			Common_DatapoolFactory theCommon_DatapoolFactory = (Common_DatapoolFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/hyades/models/common/datapool.xmi"); 
			if (theCommon_DatapoolFactory != null) {
				return theCommon_DatapoolFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new Common_DatapoolFactoryImpl();
	}

    //cached datapools          	
    private static java.util.HashMap datapoolsOpen = new java.util.HashMap();
    
    //reference counters for cached datapools
    private static java.util.HashMap datapoolRefCounts = new java.util.HashMap();           	
              	
              	
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_DatapoolFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case Common_DatapoolPackage.DPL_DATAPOOL_SPEC: return createDPLDatapoolSpec();
			case Common_DatapoolPackage.DPL_EQUIVALENCE_CLASS: return createDPLEquivalenceClass();
			case Common_DatapoolPackage.DPL_RECORD: return createDPLRecord();
			case Common_DatapoolPackage.DPL_CELL: return createDPLCell();
			case Common_DatapoolPackage.DPL_VARIABLE: return createDPLVariable();
			case Common_DatapoolPackage.DPL_DATAPOOL: return createDPLDatapool();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case Common_DatapoolPackage.DPL_ROLE:
				return createDPLRoleFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case Common_DatapoolPackage.DPL_ROLE:
				return convertDPLRoleToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapoolSpec createDPLDatapoolSpec() {
		DPLDatapoolSpecImpl dplDatapoolSpec = new DPLDatapoolSpecImpl();
		return dplDatapoolSpec;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapool createDPLDatapool() {
		DPLDatapoolImpl dplDatapool = new DPLDatapoolImpl();
		return dplDatapool;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLRole createDPLRoleFromString(EDataType eDataType, String initialValue) {
		DPLRole result = DPLRole.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDPLRoleToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLEquivalenceClass createDPLEquivalenceClass() {
		DPLEquivalenceClassImpl dplEquivalenceClass = new DPLEquivalenceClassImpl();
		return dplEquivalenceClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLRecord createDPLRecord() {
		DPLRecordImpl dplRecord = new DPLRecordImpl();
		return dplRecord;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLCell createDPLCell() {
		DPLCellImpl dplCell = new DPLCellImpl();
		return dplCell;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLVariable createDPLVariable() {
		DPLVariableImpl dplVariable = new DPLVariableImpl();
		return dplVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_DatapoolPackage getCommon_DatapoolPackage() {
		return (Common_DatapoolPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static Common_DatapoolPackage getPackage() {
		return Common_DatapoolPackage.eINSTANCE;
	}

	//Beginning of non-generated classes

	/**
	 * <p>Load the datapool from the specified file.  If a
	 * <code>sharedInstance</code> is requested then the cache of
	 * other datapools that have been opened is checked for an 
	 * existing copy of the datapool.  Note that modifying a shared
	 * instance of the datapool may effect other uses of the datapool
	 * and should only be done in a confined execution environment.</p>
	 * 
	 * <p>If the EMF test models have not been initialized (e.g. stand-alone run-times),
	 * they are initialized before the datapool is loaded.</p>
	 * 
	 * @param	dpFile			The datapool file name.
	 * @param	sharedInstance	Available for sharing instances of
	 *						the datapool, which can save significantly 
	 *						on datapool loading overhead.
	 * 
	 * @see	#unload(IDatapool)
	 */
	public IDatapool loadForEdit(java.io.File dpFile, boolean sharedInstance)
	{

		synchronized(this)  // TEST&SET  
		{		

			//Initialize the EMF test models (required for stand-alone run-times when org.eclipse.hyades.test.core.TestCorePlugin.start(BundleContext) has not been invoked):
			FacadeResourceFactoryImpl.initializeRequisiteModels();
			
			String dpAbsolutePath = dpFile.getAbsolutePath();
			IDatapool dp = (IDatapool)datapoolsOpen.get(dpAbsolutePath);
	
			//Private instance or an unloaded shared instance:
			if ((!sharedInstance ) || ((sharedInstance) && (dp == null))){
				
				//Check if the datapool file exits:
				if((!dpFile.exists())){
					throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.29", dpAbsolutePath)); //$NON-NLS-1$
				}
				else if(dpFile.length() == 0){
					throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.30", dpAbsolutePath)); //$NON-NLS-1$
				}
				
				try {
	
					DPLLogImpl.log("Load file: " + dpAbsolutePath);	//$NON-NLS-1$
					
					//Attempt to load the datapool:
					Resource resource = new ResourceSetImpl().getResource(URI.createFileURI(dpAbsolutePath), true);
					resource.load(null);
					
					IDatapool datapool = ((IDatapool)(resource.getContents().get(0)));
					
					//Cache the shared instance:
					if (sharedInstance){ 

						DPLLogImpl.log("Datapool cached, refCount = 1"); //$NON-NLS-1$

						datapoolsOpen.put(dpAbsolutePath, datapool);
						datapoolRefCounts.put(dpAbsolutePath, new Integer(1));
					}
					
					((DPLDatapoolImpl)(datapool)).setAbsoluteFilePathname(dpAbsolutePath);
					
					return datapool;
				}
				catch (WrappedException w){
					throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.21", dpAbsolutePath), w.getCause()); //$NON-NLS-1$				
				}
				catch (Throwable t){					
					throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.21", dpAbsolutePath), t); //$NON-NLS-1$
				}	
			}
			else //shared instance, already loaded
			{
				Integer refCount = ((Integer)datapoolRefCounts.remove(dpAbsolutePath));			
				Integer newRefCount =  new Integer(refCount.intValue()+1);
				DPLLogImpl.log("Refcount: " + newRefCount.intValue());			 //$NON-NLS-1$
				datapoolRefCounts.put(dpAbsolutePath,newRefCount);
				return dp;
			}		
		} //synchronized(this)
	}
	
	/**
	 * Removes a reference to an instance of a datapool.  If the
	 * datapool is shared the reference count is reduced.  Once 
	 * all references to a datapool have been unloaded the datapool
	 * instance will be made available to garbage collection.
	 * 
	 * @param	datapool	The datapool instance being unloaded.
	 * 
	 * @see	#load(java.io.File,boolean)
	 */
	public void unload(IDatapool datapool)
	{
		String dpAbsolutePath = ((DPLDatapoolImpl)datapool).getAbsoluteFilePathname();
		                      
		synchronized(this) {  //this is TEST&SET
		Integer refCount = ((Integer)datapoolRefCounts.remove(dpAbsolutePath));
		
			if (refCount != null && refCount.intValue() > 1)
			{			
				// decrement reference count
				Integer newRefCount =  new Integer(refCount.intValue()-1);
				DPLLogImpl.log("Refcount: " + newRefCount.intValue());			 //$NON-NLS-1$
				datapoolRefCounts.put(dpAbsolutePath, newRefCount);
			}
			else
			if (refCount != null && refCount.intValue() == 1)
			{
				//remove the reference
				DPLLogImpl.log("datapool uncached"); //$NON-NLS-1$
				datapoolsOpen.remove(dpAbsolutePath);
			}
			else
			{
				//datapool was not cached - do nothing
			}
		} //synchronized(this)
	}
	
	/**
	 * Persists the specified instance of a datapool.  The file 
	 * used is the same as the file from which the datapool was 
	 * loaded.  If the datapool was constructed from scratch the
	 * {@link #saveAs(IDatapool,java.io.File) saveAs} method
	 * should be used to save the file.
	 * 
	 * @param	datapool	The datapool instance being saved.
	 * 
	 * @see	#load(java.io.File,boolean)
	 * @see	#unload(IDatapool)
	 * @see	#saveAs(IDatapool,java.io.File)
	 */
	public void save(IDatapool datapool)
	{
		this.saveAs(datapool, new java.io.File(
			 ((DPLDatapoolImpl)datapool).getAbsoluteFilePathname()));
	}
	
	/**
	 * Persists the specified instance of a datapool to the 
	 * specified file.
	 * 
	 * @param	datapool	The datapool instance being saved.
	 * @param	dpFile		The file to which the datapool is to be saved.
	 * 
	 * @see	#load(java.io.File,boolean)
	 * @see	#unload(IDatapool)
	 * @see	#save(IDatapool)
	 */
	public void saveAs(IDatapool datapool, java.io.File dpFile){

		String dpAbsolutePath = dpFile.getAbsolutePath();

		try {
			
			DPLLogImpl.log("Save file: " + dpAbsolutePath); //$NON-NLS-1$

			Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
			
			Map m = reg.getExtensionToFactoryMap();
			m.put("xmi", new XMIResourceFactoryImpl()); //$NON-NLS-1$
			
			ResourceSet resourceSet = new ResourceSetImpl();
			resourceSet.getResourceFactoryRegistry();
			
			Resource res = resourceSet.createResource(URI.createFileURI(dpAbsolutePath));	
			res.getContents().add((EObject)datapool);
			res.save(Collections.EMPTY_MAP);
		}
		catch (WrappedException w){
			throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.27", dpAbsolutePath), w.getCause()); //$NON-NLS-1$				
		}
		catch (Throwable t){
			throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.27", dpAbsolutePath), t); //$NON-NLS-1$
		}
	
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory methods
	
	/**
	 * <p>Load the datapool from the specified file.  If a
	 * <code>sharedInstance</code> is requested then the cache of
	 * other datapools that have been opened is checked for an 
	 * existing copy of the datapool.  Note that modifying a shared
	 * instance of the datapool may effect other uses of the datapool
	 * and should only be done in a confined execution environment.</p>
	 * 
	 * <p>If the EMF test models have not been initialized (e.g. stand-alone run-times),
	 * they are initialized before the datapool is loaded.</p>
	 * 
	 * @param	dpFile			The datapool file name.
	 * @param	sharedInstance	Available for sharing instances of
	 *						the datapool, which can save significantly 
	 *						on datapool loading overhead.
	 * 
	 * @see	#unload(IDatapool)
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapool load
											(java.io.File dpFile, boolean sharedInstance)
	{
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapool)
						 (this.loadForEdit(dpFile, sharedInstance));
	}
	
	/**
	 * Removes a reference to an instance of a datapool.  If the
	 * datapool is shared the reference count is reduced.  Once 
	 * all references to a datapool have been unloaded the datapool
	 * instance may be made available to garbage collection.
	 * 
	 * @param	datapool	The datapool instance being unloaded.
	 * 
	 * @see	#load(java.io.File,boolean)
	 */
	public void unload(org.eclipse.hyades.execution.runtime.datapool.IDatapool datapool)
	{
		this.unload((IDatapool) datapool);
	}
	
	/**
	 * Return an iterator instance implemented by the extension with given extensionId.
	 * 
	 * 
	 * @param	datapool	The datapool instance being iterated over.
	 * 
	 * @see	#close(IDatapoolIterator)
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator open
								  (org.eclipse.hyades.execution.runtime.datapool.IDatapool datapool,
								  String iteratorExtensionId)
	{
		
		//get extension point fot iterator extensions		
		org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator myIterator = null;
		Class myIteratorClass = null;
		
		try {
		    IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint
			   ("org.eclipse.tptp.platform.models.datapool_iterator");	    	        //$NON-NLS-1$
		    DPLLogImpl.log("iterator ext point found!!!"); //$NON-NLS-1$
		
		    //find all extensions
			IExtension[] extensions = extPoint.getExtensions();                
			DPLLogImpl.log("extensions.length: " + extensions.length); //$NON-NLS-1$
			
			//look for extension with id of iteratorExtensionId
			int i = 0;
			boolean found = false;
			while (!found && i < extensions.length)
			{                    	
				IExtension currentExtension = extensions[i];
				DPLLogImpl.log("   extension:" + currentExtension.getUniqueIdentifier()); //$NON-NLS-1$
				
				if (iteratorExtensionId.equals(currentExtension.getUniqueIdentifier()))
				{					
					IConfigurationElement[] configElements =
					   currentExtension.getConfigurationElements();
					DPLLogImpl.log("configElements.length : " + configElements.length); //$NON-NLS-1$
					//only one config element allowed
					IConfigurationElement currentConfigElement = configElements[0];
                    
					myIterator = (org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
							   currentConfigElement.createExecutableExtension("class"); //$NON-NLS-1$
						       
					DPLLogImpl.log("iterator: " + myIterator.toString()); //$NON-NLS-1$
					myIteratorClass = myIterator.getClass();
					found = true;	     																				    
				}
				else
				   i++;                   	   
			}
			if (!found)					    
			    throw new DatapoolException();  //$NON-NLS-1$
		}   
		catch (Throwable t) {			
			try 
			{
				myIteratorClass  = Class.forName(iteratorExtensionId);
			}
			catch (Throwable t1 )
			{
				throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.23", iteratorExtensionId));  //$NON-NLS-1$
			}
		}				

		try
		{   		    
			java.lang.reflect.Method getInstanceMethod = (myIteratorClass.getMethod("getInstance", new java.lang.Class[0])); //$NON-NLS-1$
			return ((org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
							 getInstanceMethod.invoke(null, new Object[0]));    
		}
		catch (NoSuchMethodException e)
		{
			try {
			
				java.lang.reflect.Constructor ctor = myIteratorClass.getConstructor(new java.lang.Class[0]);
				return ((org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator)
					 ctor.newInstance(new Object[0]));
			}
			catch( Throwable t)
			{
				throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.25", iteratorExtensionId), t); //$NON-NLS-1$
			}
		}
		catch (Throwable t)
		{
			throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.25", iteratorExtensionId), t); //$NON-NLS-1$
		}
        		
	}
		
	/**
	 * Return the iterator to the factory so that it can be properly 
	 * destroyed.  Note that if shared the iterator will not be destructed 
	 * until all uses have been accounted for.
	 * 
	 * @param	iterator	The iterator being freed.
	 * 
	 * @see	#open(IDatapool,String)
	 */
	public void close(org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator iterator)
	{
		try
		{   		    
			java.lang.reflect.Method closeMethod = (iterator.getClass()).getMethod("close", new java.lang.Class[0]); //$NON-NLS-1$
			closeMethod.invoke(null, new Object[0]);    
		}
		catch (NoSuchMethodException e)
		{
			//do nothing
		}
		catch (Throwable t)
		{
			throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.28"), t); //$NON-NLS-1$
		}
	}
	
	public IDatapoolSuggestedType createDatapoolSuggestedType()
	{
		return new DatapoolSuggestedTypeImpl();
	}

	/**
	 * Constructs and returns an empty IDataPool
	 */
	public IDatapool constructDatapool()
	{
		DPLDatapoolImpl datapool = new DPLDatapoolImpl();
		DPLDatapoolSpecImpl datapoolSpec = new DPLDatapoolSpecImpl();
		datapool.setDatapoolSpec(datapoolSpec);
		return (IDatapool)datapool; 	
	}

} //Common_DatapoolFactoryImpl
