/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: DPLVariableImpl.java,v 1.13 2009/05/05 15:51:28 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.internal.util.DatapoolSuggestedTypeChecker;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Variable</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#isEncrypted <em>Encrypted</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl#getVariables <em>Variables</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLVariableImpl extends CMNNamedElementImpl 
                             implements DPLVariable
{
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected static final DPLRole ROLE_EDEFAULT = DPLRole.UNSPECIFIED_DATA_LITERAL;

	/**
	 * The cached value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected DPLRole role = ROLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isEncrypted() <em>Encrypted</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEncrypted()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ENCRYPTED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isEncrypted() <em>Encrypted</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isEncrypted()
	 * @generated
	 * @ordered
	 */
	protected boolean encrypted = ENCRYPTED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<DPLVariable> variables;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLVariableImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_DatapoolPackage.Literals.DPL_VARIABLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLRole getRole() {
		return role;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRole(DPLRole newRole) {
		DPLRole oldRole = role;
		role = newRole == null ? ROLE_EDEFAULT : newRole;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__ROLE, oldRole, role));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isEncrypted() {
		return encrypted;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEncrypted(boolean newEncrypted) {
		boolean oldEncrypted = encrypted;
		encrypted = newEncrypted;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_VARIABLE__ENCRYPTED, oldEncrypted, encrypted));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DPLVariable> getVariables() {
		if (variables == null) {
			variables = new EObjectContainmentEList<DPLVariable>(DPLVariable.class, this, Common_DatapoolPackage.DPL_VARIABLE__VARIABLES);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
				return ((InternalEList<?>)getVariables()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				return getType();
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				return getRole();
			case Common_DatapoolPackage.DPL_VARIABLE__ENCRYPTED:
				return isEncrypted();
			case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
				return getVariables();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				setType((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				setRole((DPLRole)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ENCRYPTED:
				setEncrypted((Boolean)newValue);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection<? extends DPLVariable>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				setRole(ROLE_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__ENCRYPTED:
				setEncrypted(ENCRYPTED_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
				getVariables().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_DatapoolPackage.DPL_VARIABLE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_DatapoolPackage.DPL_VARIABLE__ROLE:
				return role != ROLE_EDEFAULT;
			case Common_DatapoolPackage.DPL_VARIABLE__ENCRYPTED:
				return encrypted != ENCRYPTED_EDEFAULT;
			case Common_DatapoolPackage.DPL_VARIABLE__VARIABLES:
				return variables != null && !variables.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", role: ");
		result.append(role);
		result.append(", encrypted: ");
		result.append(encrypted);
		result.append(')');
		return result.toString();
	}

	
	//Beginning of non-generated classes
	
	//org.eclipse.hyades.edit.datapool.IDatapoolVariable methods
	
	IDatapoolSuggestedType suggestedType = null;
	
	/**
	 * Define the {@link IDatapoolSuggestedType type} associated with this variable.
	 * 
	 * @param	suggestedType	The {@link IDatapoolSuggestedType type} associated 
	 *							with this variable.
	 * 
	 * @see #getSuggestedType()
	 */
	public void setSuggestedType(IDatapoolSuggestedType suggestedType)
	{
		this.setType(suggestedType.getSuggestedClassName());		
		this.suggestedType = suggestedType;

		//notify datapool listener  
		DPLDatapoolSpec dpSpec = (DPLDatapoolSpec)this.eContainer();
		if(dpSpec == null)
			return;
		DPLDatapool dp = (DPLDatapool)dpSpec.eContainer();	
		if(dp == null)
			return;	
		IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
	    for(int i = 0; i < listeners.length; i++)
	        ((IDatapoolListener)listeners[i]).variableChanged((IDatapool)dp,  
							  dp.getDatapoolSpec().getVariables().indexOf(this));				
	}
		
	
	/**
	 * Define the role associated with a variable.
	 * 
	 * @param	role	The role to associate with a variable.
	 * 
	 * @see #getRole()
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public void setRole(int role)
	{
		this.setRole(DPLRole.get(role));
	}
	
	//org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable methods
		
	/**
	 * The {@link IDatapoolSuggestedType suggested type} of the data associated
	 * with this variable.  As implied by the name there is no enforcement of
	 * the type of data in any cell of the datapool.  However, an editor could 
	 * take advantage of the type information to improve display and editing of
	 * cells within the display.
	 * 
	 * @return	The {@link IDatapoolSuggestedType suggested type} associated with
	 *			this variable.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType getSuggestedType(){
		
		if(suggestedType == null){
			
			suggestedType = new DatapoolSuggestedTypeImpl();
			String type = this.getType();
			
			try{		
				suggestedType.setSuggestedType(Integer.parseInt(type));
			}
			catch(NumberFormatException n){
				
			    if((type != null) && (type.trim().length() > 0)){
					DatapoolSuggestedTypeChecker.getInstance().setVariableType(suggestedType, type);
			    }
			    else{
			        
			    	suggestedType.setSuggestedType(IDatapoolSuggestedType.TYPE_STRING);
			        
			        setType(suggestedType.getSuggestedClassName());
			    }
			}
			catch(DatapoolException d){

			    if((type != null) && (type.trim().length() > 0)){
					DatapoolSuggestedTypeChecker.getInstance().setVariableType(suggestedType, type);
			    }
			    else{
			        
			    	suggestedType.setSuggestedType(IDatapoolSuggestedType.TYPE_STRING);
			        
			        setType(suggestedType.getSuggestedClassName());
			    }
			}
		}
		
		return ((org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType)(suggestedType));      
	}

		
	/**
	 * Accesor for the role associated with a variable.  The role may be
	 * used by an editor to control the type of data that may be applied to 
	 * an individual cell with a datapool.
	 * 
	 * @return The role associated with a variable.
	 * 
	 * @see	#ROLE_UNSPECIFIED
	 * @see	#ROLE_INPUT_DATA
	 * @see	#ROLE_OUTPUT_DATA
	 * @see	#ROLE_INPUT_OUTPUT_DATA
	 * @see	#ROLE_VERIFICATION_DATA
	 */
	public int getRoleAsInt()
	{
		return this.getRole().getValue();
	}

	public void setName(String name)
	{
		super.setName(name);

		//notify datapool listener  
		DPLDatapoolSpec dpSpec = (DPLDatapoolSpec)this.eContainer();
		if(dpSpec == null)
			return;
		DPLDatapool dp = (DPLDatapool)dpSpec.eContainer();	
		if(dp == null)
			return;	
		IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
	    for(int i = 0; i < listeners.length; i++)
	        ((IDatapoolListener)listeners[i]).variableChanged((IDatapool)dp,  
							  dp.getDatapoolSpec().getVariables().indexOf(this));		
	}

} //DPLVariableImpl
