/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_DatapoolAdapterFactory.java,v 1.11 2009/05/05 15:51:28 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage
 * @generated
 */
public class Common_DatapoolAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_DatapoolPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_DatapoolAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = Common_DatapoolPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Common_DatapoolSwitch<Adapter> modelSwitch =
		new Common_DatapoolSwitch<Adapter>() {
			@Override
			public Adapter caseDPLDatapoolSpec(DPLDatapoolSpec object) {
				return createDPLDatapoolSpecAdapter();
			}
			@Override
			public Adapter caseDPLEquivalenceClass(DPLEquivalenceClass object) {
				return createDPLEquivalenceClassAdapter();
			}
			@Override
			public Adapter caseDPLRecord(DPLRecord object) {
				return createDPLRecordAdapter();
			}
			@Override
			public Adapter caseDPLCell(DPLCell object) {
				return createDPLCellAdapter();
			}
			@Override
			public Adapter caseDPLVariable(DPLVariable object) {
				return createDPLVariableAdapter();
			}
			@Override
			public Adapter caseDPLDatapool(DPLDatapool object) {
				return createDPLDatapoolAdapter();
			}
			@Override
			public Adapter caseCMNNamedElement(CMNNamedElement object) {
				return createCMNNamedElementAdapter();
			}
			@Override
			public Adapter caseCFGClass(CFGClass object) {
				return createCFGClassAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec <em>DPL Datapool Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec
	 * @generated
	 */
	public Adapter createDPLDatapoolSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLDatapool <em>DPL Datapool</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLDatapool
	 * @generated
	 */
	public Adapter createDPLDatapoolAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass <em>DPL Equivalence Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass
	 * @generated
	 */
	public Adapter createDPLEquivalenceClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLRecord <em>DPL Record</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLRecord
	 * @generated
	 */
	public Adapter createDPLRecordAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLCell <em>DPL Cell</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLCell
	 * @generated
	 */
	public Adapter createDPLCellAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.datapool.DPLVariable <em>DPL Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.datapool.DPLVariable
	 * @generated
	 */
	public Adapter createDPLVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.common.CMNNamedElement <em>CMN Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement
	 * @generated
	 */
	public Adapter createCMNNamedElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.configuration.CFGClass <em>CFG Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass
	 * @generated
	 */
	public Adapter createCFGClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //Common_DatapoolAdapterFactory
