/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DPLPasswordCollection.java,v 1.2 2008/04/30 23:41:13 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.models.common.datapool.util;

import java.util.HashMap;

/**
 * Represents a static map contains datapools (keys) and passwords (values).
 * <p/>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @author      Huang Xin Ying 
 * @version     April 30, 2008
 * @since       March 20, 2008
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public class DPLPasswordCollection {
	
	private HashMap datapoolPassword = null;

	private static DPLPasswordCollection instance = null;

	/**
	 * Private constructor.
	 */
	private DPLPasswordCollection() {
		datapoolPassword = new HashMap();
	}

	/**
	 * Gets the singleton instance. 
	 * <p/>
	 * 
	 * @return Singleton instance. 
	 */
	public static DPLPasswordCollection getInstance() {
		
		if (instance == null) {
			instance = new DPLPasswordCollection();
		} 
		
		return instance;
	}

	/**
	 * Retrieves the datapool password map, otherwise <code>null</code>. 
	 * <p/>
	 * 
	 * @return The the datapool password map, otherwise <code>null</code>. 
	 */
	public HashMap getDatapoolPassword() {
		return datapoolPassword;
	}

	/**
	 * Sets a new datapool password map.
	 * <p/>
	 * 
	 * @param datapoolPassword The new datapool password map.
	 */
	public void setDatapoolPassword(HashMap datapoolPassword) {
		this.datapoolPassword = datapoolPassword;
	}
	
	/**
	 * Clear the datapool password map, if not <code>null</code>. 
	 */
	public void clear(){
		
		if(datapoolPassword != null){
			datapoolPassword.clear();
		}
	}	
}
