/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAction.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * <p>An IAction is the most fine grained specification of the behavior of a test.  
 * IAction is extended by {@link ITargetInvocation}, {@link IDecision}, {@link ILoop}, 
 * {@link ITestInvocation}, and {@link IVerificationPoint}.  These interfaces define 
 * the building blocks with which you can construct a behavioral specification of 
 * your test.</p>
 *  
 * <p>In the mapping of the behavioral facade to the Test Model, an action is an
 * interaction fragment</p> 
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface IAction extends INamedElement {

	/**
	 * Returns the synchonization state of the action.  A true indicates that 
	 * the action is to be invoked in parallel.  A false return indicates that 
	 * the action is to be invoked in series.
	 * 
	 * <p>If the action implementation doesn't support this
	 * concept this method must return true.</p>
	 * 
	 * @return boolean
	 */
	public boolean isSynchronous();
	
	/**
	 * Sets the synchonization state of the action.  Setting the state to true
	 * means that the action is to be invoked in parallel.  A false setting
	 * means that the action is to be invoked in series. 
	 * 
	 * <p>If the action implementation doesn't support this
	 * concept this method should throw UnsupportedOperationException.</p>
	 * 
	 * @param synchronous
	 * @throws UnsupportedOperationException
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException;
	
	/**
	 * Returns the properties of an action.  Properties are pairs of name and
	 * value.
	 * 
	 * @return IPropertyGroup
	 */	
	public IPropertyGroup getActionProperties();	
	
	/**
	 * Returns the annotations of an action.  
	 * @see IAnnotation
	 * @return List
	 */
	public List getActionAnnotations();
}
