/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAnnotatableResource.java,v 1.1 2009/04/27 15:21:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.models.common.facades.behavioral;

import java.io.IOException;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.common.common.CMNAnnotation;

/**
 * Resources that implement this interface support annotation files within
 * their models.
 * 
 * @author jtoomey
 * @provisional
 */
public interface IAnnotatableResource {

	URI getFileAnnotation(CMNAnnotation annotationElement) throws IOException;

	void putFileAnnotation(URI file, CMNAnnotation annotationElement) throws IOException;

	void removeFileAnnotation(CMNAnnotation annotationElement) throws IOException;

	boolean isFileAnnotation(CMNAnnotation annotationElement);

}
