/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAnnotation.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.io.IOException;

import org.eclipse.emf.common.util.URI;

/**
 * 
 * <p>An IAnnotation is a model element that annotates another model element with 
 * some data that is not described directly by the model.  Collections of 
 * anotations are available on instances of all {@link IAction}</p>
 *  
 * <p>
 * Annotations can currently be only files.  File Annotations are annotations that are 
 * files which are attached to the model and persisted within the same resource as the 
 * model element to which the annotation applies.  In order to annotate a model element
 * with a File Annotation, you must first create the Annotation object (using 
 * HyadesFactory.INSTANCE.createAnnotation()).  You must then add that Annotation object
 * to the collection of annotation objects for the model element you are annotating.
 * Then you can call putFileAnnotation(URI file) on the Annotation object, passing the
 * URI of the file you want to annotate the model object with.  This will ensure that
 * the specified file is copied into the resource when the resource is saved.  
 * </p>
 * 
 * <p>
 * When looking at a model element that currently contains one or more Annotations
 * in its annotation collection, you may simply retrieve the Annotation object, and
 * call getFileAnnotation().  This returns a file URI to a location from which the
 * file annotation may currently be read.  
 * </p>
 * 
 * <p>
 * When removing a file annotaion from a model element's annotation collection, be sure
 * to first call removeFileAnnotation() on the Annotation object in order to free
 * up the file from the collection of files that will be persisted with the element's
 * resource.
 * </p>
 * 
 * <p>
 * You must use <code>FacadeResourceFactoryImpl</code> as the registered factory for
 * any resources that will contain annotated model elements.  You also <b>must</b>
 * ensure that you call Resource.unload() on all resources with annotated model
 * elements when you have finished with the resource.  Failing to do so will result
 * in orphaned temporary files. 
 * </p>
 * 
 * <p>
 * For examples of how to use the methods of this class, please see 
 * ValidateFacadeImpl.testPutAnnotations(), testGutAnnotations(), testRemoveAnnotations() 
 * </p>
 * 
 * <p>In the mapping of the behavioral facade to the Test Model, an IAnnotation 
 * is a CMNAnnotation.</p> 
 * 
 * @author jtoomey
 * @since 3.0
 */
public interface IAnnotation {
	
	public String getType();	
	public boolean isFileAnnotation();
	public void putFileAnnotation(URI file) throws UnsupportedOperationException, IOException;
	public URI getFileAnnotation() throws UnsupportedOperationException, IOException;
	public void removeFileAnnotation() throws UnsupportedOperationException, IOException;
	
}
