/*******************************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProjectBasedComponent.java,v 1.5 2010/04/12 12:38:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import org.eclipse.emf.common.util.URI;

/**
 * <p>This interface defines any component that is part of a project.</p>
 * 
 * 
 * @author  Bianca Xue Jiang
 * @author  Joseph Toomey
 * @author  Paul Slauenwhite
 * @version April 12, 2010
 * @since   January 25, 2005
 */
public interface IProjectBasedComponent
{
    /**
     * Returns the project of this component.
     * 
     * @return the project
     */
    public String getProject();
    
    /**
     * <p>Returns the non-encoded platform-relative URI. The result 
     * will be of this form:</p>
     * 
     * <p><code>platform:/resource/project-name/path</code></p>
     * 
     * @return The non-encoded platform-relative URI.
     */
    public URI getPlatformURI();
	
}
