/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITargetInvocation.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A target invocation is an action that is a particular communication between
 * the component that the action belongs to and a target component.  This can be
 * visualized as a method invocation on a system under test (SUT).  The specifics 
 * of the invocation are captured in the properties of the target invocation.
 * 
 * @author marcelop
 * @author serge
 * @author psun
 * @author jtoomey
 * @since 0.0.1
 */
public interface ITargetInvocation extends IAction
{
	/**
	 * Returns the target component for the invocation.
	 * 
	 * <p>This reference is unidirectional.
	 * 
	 * @return IDeployableComponent
	 * 
	 */
	public IDeployableComponent getTarget();

	/**
	 * Returns the IMethod that is invoked by the TargetInvocation.
	 * 
	 * @return IMethod
	 */
	public IMethod getInvocation();
	
	/**
	 * Assigns the method to be invoked.
	 * 
	 * @param method 
	 */
	public void setInvocation(IMethod method);
}
