/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestInvocation.java,v 1.3 2006/02/08 19:59:48 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A test invocation is an action that invokes another test.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ITestInvocation extends IAction {	

	/**
	 * Returns the test that is associated with this invocation.
	 * 
	 * <p>This reference is unidirectional
	 * 
	 * @return ITest
	 */
	public ITest getInvokedTest();

	/**
	 * Sets the test for this invocation.
	 * 
	 * <p>The reference is unidirectional
	 * 
	 * @param test
	 */
	public void setInvokedTest(ITest test);
}
