/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionFacadeResourceImpl.java,v 1.11 2009/01/09 12:34:11 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;

/**
 * @deprecated Use {@link FacadeResourceImpl}.
 */
public class ExecutionFacadeResourceImpl extends FacadeResourceImpl
{
	private EList verdictLists;

	public ExecutionFacadeResourceImpl()
	{
		super();
	}

	public ExecutionFacadeResourceImpl(URI arg0)
	{
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl#attached(org.eclipse.emf.ecore.EObject)
	 */
	public void attached(EObject arg0)
	{
		super.attached(arg0);
		
		if(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent().isSuperTypeOf(arg0.eClass()))
		{
			TPFVerdictEvent verdictEvent = (TPFVerdictEvent)arg0;
			
			// TODO: make verdict type to be based on TPFVerdictReason 
			// when mapping between TPFVerdictReason and TPFVerdict becomes available.
			TPFVerdictList verdictList = getVerdictList(verdictEvent.getVerdict().getName());
			if(verdictList != null)
				verdictList.getVerdictEvents().add(verdictEvent);
			
			// add to the "allTypes" verdict list
			verdictList = getVerdictList(TPFVerdictList.VERDICT_TYPE_ALL);
			if(verdictList != null)
				verdictList.getVerdictEvents().add(verdictEvent);
		}
	}

	// TODO: Looks like there should be a corresponding detached() method here 
	// to clean up what was done in the attach() method above.
	
	
	/**
	 * From the <code>TPFExecutionResult</code> object of this resource, find the <code>TPFVerdictList</code>
	 * of the specified <i>type</i> within the 'Verdict Lists' containment references. A new <code>TPFVerdictList</code>
	 * will be created if not exist yet.
	 * 
	 * @param type type of the <code>TPFVerdictList</code> contained by this <code>TPFExecutionResult</code> resource.
	 */
	protected TPFVerdictList getVerdictList(String type)
	{
		if(verdictLists == null)
		{
			EList contents = getContents();
			if(!contents.isEmpty() && contents.get(0) instanceof TPFExecutionResult)
			{
				verdictLists = ((TPFExecutionResult)contents.get(0)).getVerdictLists();
			}
			else
				return null;
		}
			
		for(int i = 0; i < verdictLists.size(); i++)
		{
			TPFVerdictList verdictList = (TPFVerdictList)verdictLists.get(i);
			if(verdictList.getType() != null && verdictList.getType().equals(type))
				return verdictList;
		}
		
		TPFVerdictList newVerdictList = Common_TestprofileFactory.eINSTANCE.createTPFVerdictList();
		newVerdictList.setType(type);
		verdictLists.add(newVerdictList);
		return newVerdictList;
	}

	
	protected void doUnload() {
		if (verdictLists != null) {
			verdictLists.clear();
			verdictLists = null;
		}		
		super.doUnload();
	}
	
}
