/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesTPFTestSuiteAdapter.java,v 1.5 2008/05/30 18:37:07 dmorris Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author jtoomey
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesTPFTestSuiteAdapter extends AdapterImpl {

	/**
	 * 
	 */
	public HyadesTPFTestSuiteAdapter() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object arg0) {
	  if (arg0 instanceof EObject)
	  {
		return ((EObject)arg0).eClass() == Common_TestprofilePackage.eINSTANCE.getTPFTestSuite();
	  }
	  return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
				
		int eventType = notification.getEventType();
			
		if ( eventType == Notification.ADD ||
			 eventType == Notification.ADD_MANY ||
			 eventType == Notification.REMOVE ||
			 eventType == Notification.REMOVE_MANY )
		{
			TPFTestSuiteImpl suite = (TPFTestSuiteImpl) notification.getNotifier();
			if(!FacadeResourceFactoryImpl.PERSISTENCE_ID.equals(suite.getPersistenceId()))
			{
				return;
			}
			Iterator iter = null;
			switch (notification.getFeatureID(TPFTestSuite.class))
			{
				case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
					IImplementor implementor = ((ITestSuite)suite).getImplementor();
					IBlock block = null;
					if(implementor != null)
					{
						block = implementor.getBlock();
					}
					CFGClassImpl sut = null;
					TPFSUTImpl systemUnderTest = null;
					List systemsUnderTest = null;
					int numOfInstances = 0;

					switch(eventType){
						case Notification.ADD:
							systemUnderTest = (TPFSUTImpl)notification.getNewValue();
						
							sut = (CFGClassImpl)systemUnderTest;
							if(sut.getInstances().size() > 0)
							{
								if(((CFGInstanceImpl)sut.getInstances().get(0)).getLifeline() == null)
								{
									if(block != null)
									{
										BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
										((CFGInstanceImpl)sut.getInstances().get(0)).setLifeline(lifeline);
										((BVRInteractionImpl)block).getLifelines().add(lifeline); 
									}
								}
							}	
							break;			
						case Notification.ADD_MANY:
							systemsUnderTest = (List)notification.getNewValue();
							iter = systemsUnderTest.iterator();
							while (iter.hasNext()) {							
								sut = (CFGClassImpl)iter.next();
								if(sut.getInstances().size() > 0)
								{
									if(((CFGInstanceImpl)sut.getInstances().get(0)).getLifeline() == null)
									{
										if(block != null)
										{
											BVRLifelineImpl lifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
											((CFGInstanceImpl)sut.getInstances().get(0)).setLifeline(lifeline);
											((BVRInteractionImpl)block).getLifelines().add(lifeline); 
										}
									}
								}	
							}
							
							break;
						case Notification.REMOVE:
							systemUnderTest = (TPFSUTImpl)notification.getOldValue();
							sut = (CFGClassImpl)systemUnderTest;
							
							// go through instances of the SUT, get the lifeline, and remove it from the interaction
							numOfInstances = sut.getInstances().size();							
							for(int i = 0; i < numOfInstances; i++)
							{
								BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut.getInstances().get(i)).getLifeline();
								lifeline.getInteraction().getLifelines().remove(lifeline);
								sut.getInstances().remove(i); 
							}							
							break;
						case Notification.REMOVE_MANY:
							systemsUnderTest = (List)notification.getOldValue();
							iter = systemsUnderTest.iterator();
							while (iter.hasNext()) {							
								sut = (CFGClassImpl)iter.next();

								// go through instances of the SUT, get the lifeline, and remove it from the interaction
								numOfInstances = sut.getInstances().size();							
								for(int i = 0; i < numOfInstances; i++)
								{
									BVRLifelineImpl lifeline = (BVRLifelineImpl)((CFGInstanceImpl)sut.getInstances().get(i)).getLifeline();
									lifeline.getInteraction().getLifelines().remove(lifeline);
									sut.getInstances().remove(i); 
								}							
							}
							break;					
					}
					break;
				
				case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:			
					break;
				
				case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
					// If one or more test cases have been removed, we must
					// fix up the relationship between the lifelines from 
					// those testcases' interactions and the CFGInstances that
					// they were associated to.
					switch(eventType){
						case Notification.REMOVE:
							TPFTestCase testcase = (TPFTestCase)notification.getOldValue();
							TPFBehavior behavior = testcase.getBehavior();
							removeAllInvocations(suite, behavior);
							removeTPFBehaviorInstances(behavior);
						break;
					case Notification.REMOVE_MANY:
						List testcases = (List)notification.getOldValue();
						iter = testcases.iterator();
						while (iter.hasNext()) {
							testcase = (TPFTestCase) iter.next();
							behavior = testcase.getBehavior();
							removeTPFBehaviorInstances(behavior);
						}
						break;					
					}
					break;

			}
		
		}
	}
	
	/**
	 * @param suite
	 * @param behavior
	 */
	public static void removeAllInvocations(TPFTestSuite suite, TPFBehavior behavior) {
		// For all behaviors in this test suite, and remove any 
		// invocations of the specified behavior
		
		// Test Suite's default behavior
		TPFBehavior currentBehavior = suite.getBehavior();
		removeInvocationsFromBehavior(currentBehavior, behavior);
		
		// All Test Case Behaviors
		Iterator iter = suite.getTestCases().iterator();
		while (iter.hasNext())
		{
			TPFTestCase testcase = (TPFTestCase) iter.next();
			removeInvocationsFromBehavior(testcase.getBehavior(), behavior);				
		}
		
		// All Test Component behaviors
		iter = suite.getTestComponents().iterator();
		while (iter.hasNext())
		{
			TPFTestComponent testComponent = (TPFTestComponent) iter.next();
			Iterator iter2 = testComponent.getBehaviors().iterator();
			while (iter2.hasNext())
			{
				TPFBehavior testComponentBehavior = (TPFBehavior) iter2.next();
				removeInvocationsFromBehavior(testComponentBehavior, behavior);
			}
		}
		
	}

	/**
	 * @param currentBehavior
	 * @param behavior
	 */
	public static void removeInvocationsFromBehavior(TPFBehavior currentBehavior, TPFBehavior behavior) {
		// Iterate through all Iteraction Fragements in this behavior, and remove
		// any BVRExecutionOccurrances that invoke the specified behavior
		if ( currentBehavior != null && behavior != null )
		{
			BVRInteraction interaction = currentBehavior.getInteraction();
			if ( interaction != null )
			{
				Iterator iter = interaction.getInteractionFragments().iterator();
				ArrayList fragments = new ArrayList();
				while ( iter.hasNext() )
				{
					BVRInteractionFragment fragment = (BVRInteractionFragment) iter.next();
					getInvocationsFromFragment(fragment, behavior, fragments);
				}
				Iterator iter2 = fragments.iterator(); 
				while (iter2.hasNext())
				{
					EObject fragment = (EObject) iter2.next();
					EcoreUtil.remove(fragment);
				}
			}
		}
	}

	/**
	 * @param fragment
	 * @param behavior
	 * @param fragments The list of fragments that within the specified fragment that invoke the
	 * specified behavior. 
	 */
	private static void  getInvocationsFromFragment(BVRInteractionFragment fragment, TPFBehavior behavior, List fragments) {
		
		if ( fragment != null && behavior != null )
		{
			// First visit the fragment's children, if any.
			// Interaction Fragments that can contain other fragments are of
			// type CombinedFragment or InteractionOperand.
			if ( fragment instanceof BVRCombinedFragment )
			{
				Iterator iter = ((BVRCombinedFragment)fragment).getInteractionOperands().iterator();
				while ( iter.hasNext() )
				{
					BVRInteractionFragment childFragment = (BVRInteractionFragment) iter.next();
					getInvocationsFromFragment(childFragment, behavior, fragments);
				}
			}
			else if ( fragment instanceof BVRInteractionOperand )
			{
				Iterator iter = ((BVRInteractionOperand)fragment).getInteractionFragments().iterator();
				while ( iter.hasNext() )
				{
					BVRInteractionFragment childFragment = (BVRInteractionFragment) iter.next();
					getInvocationsFromFragment(childFragment, behavior, fragments);
				}
			}
			// If this fragment has no children, see if it is an invocation that 
			// we want to remove.
			else if ( fragment instanceof BVRExecutionOccurrence )
			{
				// bugzilla 201896, added the check for getOtherBehavior() returns null
				// if return is null, the invocation should be deleted since it no longer
				// contains a reference to an executable behavior
				TPFBehavior otherBehavior = ((BVRExecutionOccurrence)fragment).getOtherBehavior();
				if ( otherBehavior == null || behavior.equals(otherBehavior))
				{
					fragments.add(fragment);
				}
			}
		}
	}

	/**
	 * @param behavior
	 */
	public static void removeTPFBehaviorInstances(TPFBehavior behavior) {
		if ( behavior != null )
		{
			BVRInteraction interaction = behavior.getInteraction();
			if ( interaction != null )
			{
				List lifelines = interaction.getLifelines();
				Iterator lifelineIterator = lifelines.iterator();
				while ( lifelineIterator.hasNext() )
				{
					// For each lifeline from this removed behavior,
					// delete any associated CFGInstances (because those
					// instances have a back reference to the lifeline,
					// and the lifeline's container (and thus the lifeline)
					// is being removed.)  In fact, the CFGInstances were created
					// for this particular interaction, and should be removed 
					// along with the interaction.
					BVRLifeline lifeline = (BVRLifeline) lifelineIterator.next();
					Iterator instanceIterator = lifeline.getInstances().iterator();
					while ( instanceIterator.hasNext() )
					{
						CFGInstance instance = (CFGInstance) instanceIterator.next();
						CFGClass classOwner = instance.getClassOwner();
						if ( classOwner != null )
							classOwner.getInstances().remove(instance);
						CFGClass classType = instance.getClassType();
						if ( classType != null )
							classType.getInstantiations().remove(instance);						
					}
				}
			}
		}
	}

	BVRLifeline getSUTLifelineFromBlock( CFGClassImpl sut, BVRInteractionImpl block )
	{
		List lifelines = block.getLifelines();
		Iterator it = lifelines.iterator();
		
		BVRLifelineImpl retLifeline = null, tempLifeline = null;
		while ( it.hasNext() )
		{
			tempLifeline = (BVRLifelineImpl) it.next();
			CFGInstanceImpl instance = (CFGInstanceImpl)tempLifeline.getInstances().get(0);
			if (((CFGClassImpl)instance.getClassOwner()).equals(sut))
			{
				retLifeline = tempLifeline;
				break;
			}
		}
		return retLifeline;		
	}

}
