/*******************************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PropertyGroupImpl.java,v 1.3 2006/02/08 19:56:39 slavescu Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl;

/**
 * @author psun
 * @author bjiang
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PropertyGroupImpl implements IPropertyGroup {

	private List properties;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup#getProperties()
	 */
	public List getProperties() {
		// added to always return a non-null list. bjiang
		if(properties == null)
			properties = new ArrayList(); 
			
		return properties;
	}

	public void setProperties(List properties) {
		this.properties = properties;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup#getPropertyByName(java.lang.String)
	 */
	public IProperty getPropertyByName(String name) {
		for(int i = 0; i < getProperties().size(); i++)
		{
			BVRPropertyImpl currentProperty = (BVRPropertyImpl)(getProperties().get(i)); 
			if((currentProperty.getName()).equals(name))
				return currentProperty;
		}
		return null;
	}

}
