/********************************************************************** 
 * Copyright (c) 2007, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TptpBVRExecutionOccurrenceAdapter.java,v 1.4 2008/07/25 18:25:49 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.ArrayList;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;

/**
 * TptpBVRExecutionOccurrenceAdapter.java.
 * <p/>
 * 
 * 
 * @author  Joseph P. Toomey
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version July 25, 2008
 * @since   August 22, 2007
 */
public class TptpBVRExecutionOccurrenceAdapter extends AdapterImpl {

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object obj) {
		if (obj instanceof EObject)
		{
		  return ((EObject)obj).eClass() == Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		
		if (notification.getEventType() == Notification.SET)
		{
			if (isLoading((EObject) notification.getNotifier()))
				return;
			
			switch (notification.getFeatureID(BVRExecutionOccurrence.class))
			{
				case Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR:
					BVRExecutionOccurrence executionOccurrence = (BVRExecutionOccurrence) notification.getNotifier();
					ITestSuite invokedTestSuite = HyadesUtil.INSTANCE.getTestSuite(executionOccurrence.getInvokedTest());

					if (invokedTestSuite == null) {

						// The invocation is being removed -- clean up the referenced test suite collection if the invocation exists:
						TPFBehavior oldBehavior = ((TPFBehavior)(notification.getOldValue()));
						
						if(oldBehavior != null){
				 		
							ITestSuite notInvokedTestSuite = HyadesUtil.INSTANCE.getTestSuite(oldBehavior.getTest());
					 		EObject root = EcoreUtil.getRootContainer(executionOccurrence);
					 		if (root instanceof ITestSuite) {
					 			ITestSuite notInvoker = (ITestSuite) root;
					 			if(notInvoker != notInvokedTestSuite && notInvoker != null && notInvokedTestSuite != null && 
					 					!invokesTest(notInvoker, notInvokedTestSuite))
					 			{
					 				notInvoker.getIReferencedSuites().remove(notInvokedTestSuite);
					 			}
					 		}
						}
				 	}
				break;
			}			
		}
	}

	private boolean isLoading(EObject obj) {
		Resource res = obj.eResource();
		if (res != null && res instanceof FacadeResourceImpl) {
			return ((FacadeResourceImpl)res).isLoading();
		}
		return false;
	}

	private boolean invokesTest(ITestSuite notInvoker,
			final ITestSuite notInvokedTestSuite) {
		ArrayList roots = new ArrayList();
		roots.add(notInvoker);
		final MutableBoolean invokes = new MutableBoolean(false);
		
		ContainmentTraverser invokesTraverser = new ContainmentTraverser(roots) {
			protected boolean beforeChildren(EObject element) {
				if (element instanceof BVRExecutionOccurrence) {
					BVRExecutionOccurrence executionOccurrence = (BVRExecutionOccurrence) element;
					ITest test = executionOccurrence.getInvokedTest();
					if (test != null) {
						ITestSuite invokedTestSuite = HyadesUtil.INSTANCE.getTestSuite(test);
						if (invokedTestSuite.getId() == notInvokedTestSuite.getId()) {
							invokes.setState(true);
							return true;
						}
					}
				}
				return true;
			}
		};
		
		invokesTraverser.traverse();
		return invokes.getState();
	}
	
	private class MutableBoolean {
		private boolean state;
		
		public MutableBoolean (boolean state) {
			this.state = state; 
		}
		
		public void setState(boolean state) {
			this.state = state; 
		}
		
		public boolean getState() {
			return state;
		}
	}
}
