/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRInteraction.java,v 1.7 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.fragments;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Interaction</b></em>'.
 * @extends IBlock
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getFormalGates <em>Formal Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getBehavior <em>Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteraction()
 * @model
 * @generated
 */
public interface BVRInteraction extends EObject, IBlock{
	/**
	 * Returns the value of the '<em><b>Lifelines</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRLifeline}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lifelines</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lifelines</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteraction_Lifelines()
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction
	 * @model opposite="interaction" containment="true"
	 * @generated
	 */
	EList<BVRLifeline> getLifelines();

	/**
	 * Returns the value of the '<em><b>Interaction Fragments</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Fragments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Fragments</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteraction_InteractionFragments()
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction
	 * @model opposite="interaction" containment="true"
	 * @generated
	 */
	EList<BVRInteractionFragment> getInteractionFragments();

	/**
	 * Returns the value of the '<em><b>Formal Gates</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.fragments.BVRGate}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Formal Gates</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Formal Gates</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteraction_FormalGates()
	 * @model containment="true"
	 * @generated
	 */
	EList<BVRGate> getFormalGates();

	/**
	 * Returns the value of the '<em><b>Behavior</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getInteraction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Behavior</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Behavior</em>' container reference.
	 * @see #setBehavior(TPFBehavior)
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteraction_Behavior()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFBehavior#getInteraction
	 * @model opposite="interaction" required="true"
	 * @generated
	 */
	TPFBehavior getBehavior();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getBehavior <em>Behavior</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Behavior</em>' container reference.
	 * @see #getBehavior()
	 * @generated
	 */
	void setBehavior(TPFBehavior value);

} // BVRInteraction
