/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRCombinedFragmentImpl.java,v 1.9 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ICondition;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.fragments.BVRGate;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperand;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOperator;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Combined Fragment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getInteractionOperator <em>Interaction Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getGates <em>Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRCombinedFragmentImpl#getInteractionOperands <em>Interaction Operands</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRCombinedFragmentImpl extends BVRInteractionFragmentImpl	implements BVRCombinedFragment {
	/**
	 * The default value of the '{@link #getInteractionOperator() <em>Interaction Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperator()
	 * @generated
	 * @ordered
	 */
	protected static final BVRInteractionOperator INTERACTION_OPERATOR_EDEFAULT = BVRInteractionOperator.ALT_LITERAL;

	/**
	 * The cached value of the '{@link #getInteractionOperator() <em>Interaction Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperator()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionOperator interactionOperator = INTERACTION_OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getGates() <em>Gates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGates()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGate> gates;

	/**
	 * The cached value of the '{@link #getInteractionOperands() <em>Interaction Operands</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionOperands()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRInteractionOperand> interactionOperands;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRCombinedFragmentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_FragmentsPackage.Literals.BVR_COMBINED_FRAGMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionOperator getInteractionOperator() {
		return interactionOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionOperator(BVRInteractionOperator newInteractionOperator) {
		BVRInteractionOperator oldInteractionOperator = interactionOperator;
		interactionOperator = newInteractionOperator == null ? INTERACTION_OPERATOR_EDEFAULT : newInteractionOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR, oldInteractionOperator, interactionOperator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGate> getGates() {
		if (gates == null) {
			gates = new EObjectContainmentEList<BVRGate>(BVRGate.class, this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES);
		}
		return gates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRInteractionOperand> getInteractionOperands() {
		if (interactionOperands == null) {
			interactionOperands = new EObjectContainmentWithInverseEList<BVRInteractionOperand>(BVRInteractionOperand.class, this, Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OPERAND__COMBINED_FRAGMENT);
		}
		return interactionOperands;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInteractionOperands()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				return ((InternalEList<?>)getGates()).basicRemove(otherEnd, msgs);
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return ((InternalEList<?>)getInteractionOperands()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				return getInteractionOperator();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				return getGates();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return getInteractionOperands();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				setInteractionOperator((BVRInteractionOperator)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				getGates().clear();
				getGates().addAll((Collection<? extends BVRGate>)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				getInteractionOperands().clear();
				getInteractionOperands().addAll((Collection<? extends BVRInteractionOperand>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				setInteractionOperator(INTERACTION_OPERATOR_EDEFAULT);
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				getGates().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				getInteractionOperands().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERATOR:
				return interactionOperator != INTERACTION_OPERATOR_EDEFAULT;
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__GATES:
				return gates != null && !gates.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_COMBINED_FRAGMENT__INTERACTION_OPERANDS:
				return interactionOperands != null && !interactionOperands.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (interactionOperator: ");
		result.append(interactionOperator);
		result.append(')');
		return result.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ILoop#getCondition()
	 */
	public ICondition getCondition() {
		if(getInteractionOperands() != null && getInteractionOperands().size() != 0)
		{
			BVRInteractionOperandImpl interactionOperand = (BVRInteractionOperandImpl)getInteractionOperands().get(0);
			return (BVRInteractionConstraintImpl)interactionOperand.getInteractionConstraint();
		}
		return null; 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDecision#getFailureBlock()
	 */
	public IBlock getFailureBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.ALT)
		{
			// By convention, a if statement has two interaction operands where the first 
			// one is success and the second is failure.
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(1);
			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDecision#getSuccessBlock()
	 */
	public IBlock getSuccessBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.ALT)
		{
			// By convention, a if statement has two interaction operands where the first 
			// one is success and the second is failure.
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(0);

			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ILoop#getBlock()
	 */
	public IBlock getBlock() {
		if(getInteractionOperator().getValue() == BVRInteractionOperator.LOOP)
		{
			try
			{
				return (BVRInteractionOperandImpl)getInteractionOperands().get(0);
			}
			catch(IndexOutOfBoundsException e)
			{
				return null;
			}			
		}
		return null;
	}

	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
	
	
} //BVRCombinedFragmentImpl
