/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRInteractionOccurrenceImpl.java,v 1.9 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.fragments.BVRGate;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRInteractionOccurrence;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction Occurrence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOccurrenceImpl#getActualGates <em>Actual Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionOccurrenceImpl#getReferredBehavior <em>Referred Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRInteractionOccurrenceImpl extends BVRInteractionFragmentImpl implements BVRInteractionOccurrence
{
	/**
	 * The cached value of the '{@link #getActualGates() <em>Actual Gates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActualGates()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGate> actualGates;

	/**
	 * The cached value of the '{@link #getReferredBehavior() <em>Referred Behavior</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReferredBehavior()
	 * @generated
	 * @ordered
	 */
	protected BVRInteraction referredBehavior;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRInteractionOccurrenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_FragmentsPackage.Literals.BVR_INTERACTION_OCCURRENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGate> getActualGates() {
		if (actualGates == null) {
			actualGates = new EObjectContainmentEList<BVRGate>(BVRGate.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES);
		}
		return actualGates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction getReferredBehavior() {
		if (referredBehavior != null && referredBehavior.eIsProxy()) {
			InternalEObject oldReferredBehavior = (InternalEObject)referredBehavior;
			referredBehavior = (BVRInteraction)eResolveProxy(oldReferredBehavior);
			if (referredBehavior != oldReferredBehavior) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR, oldReferredBehavior, referredBehavior));
			}
		}
		return referredBehavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction basicGetReferredBehavior() {
		return referredBehavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferredBehavior(BVRInteraction newReferredBehavior) {
		BVRInteraction oldReferredBehavior = referredBehavior;
		referredBehavior = newReferredBehavior;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR, oldReferredBehavior, referredBehavior));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES:
				return ((InternalEList<?>)getActualGates()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES:
				return getActualGates();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR:
				if (resolve) return getReferredBehavior();
				return basicGetReferredBehavior();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES:
				getActualGates().clear();
				getActualGates().addAll((Collection<? extends BVRGate>)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR:
				setReferredBehavior((BVRInteraction)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES:
				getActualGates().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR:
				setReferredBehavior((BVRInteraction)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__ACTUAL_GATES:
				return actualGates != null && !actualGates.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION_OCCURRENCE__REFERRED_BEHAVIOR:
				return referredBehavior != null;
		}
		return super.eIsSet(featureID);
	}

} //BVRInteractionOccurrenceImpl
