/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRGeneralOrdering.java,v 1.7 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR General Ordering</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A GeneralOrdering represents a binary relation between two Eventoccurrences, to describe that one Eventoccurrence
 * must occur before the other.
 * 
 * This allows for instance the synchronization between two test components.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence <em>Previous Event Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence <em>Next Event Occurence</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRGeneralOrdering()
 * @model
 * @generated
 */
public interface BVRGeneralOrdering extends EObject{
	/**
	 * Returns the value of the '<em><b>Previous Event Occurrence</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getTargetGeneralOrderings <em>Target General Orderings</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Previous Event Occurrence</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Previous Event Occurrence</em>' reference.
	 * @see #setPreviousEventOccurrence(BVREventOccurrence)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRGeneralOrdering_PreviousEventOccurrence()
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getTargetGeneralOrderings
	 * @model opposite="targetGeneralOrderings" required="true"
	 * @generated
	 */
	BVREventOccurrence getPreviousEventOccurrence();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence <em>Previous Event Occurrence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Previous Event Occurrence</em>' reference.
	 * @see #getPreviousEventOccurrence()
	 * @generated
	 */
	void setPreviousEventOccurrence(BVREventOccurrence value);

	/**
	 * Returns the value of the '<em><b>Next Event Occurence</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getSourceGeneralOrderings <em>Source General Orderings</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Next Event Occurence</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Next Event Occurence</em>' reference.
	 * @see #setNextEventOccurence(BVREventOccurrence)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRGeneralOrdering_NextEventOccurence()
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getSourceGeneralOrderings
	 * @model opposite="sourceGeneralOrderings" required="true"
	 * @generated
	 */
	BVREventOccurrence getNextEventOccurence();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence <em>Next Event Occurence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Next Event Occurence</em>' reference.
	 * @see #getNextEventOccurence()
	 * @generated
	 */
	void setNextEventOccurence(BVREventOccurrence value);

} // BVRGeneralOrdering
