/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRInteractionFragment.java,v 1.7 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Interaction Fragment</b></em>'.
 * @extends IAction
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * InteractionFragment is an abstract notion of the most general interaction unit. An interaction fragment is a piece of an
 * interaction. Each interaction fragment is conceptually like an interaction by itself.
 * 
 * The containers of an InteractionFragment are:
 * - Behavior
 * - CombinedFragment
 * - InteractionOperand
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getGeneralOrderings <em>General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getDefaultApplication <em>Default Application</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment()
 * @model abstract="true"
 * @generated
 */
public interface BVRInteractionFragment extends CMNNamedElement, IAction{
	/**
	 * Returns the value of the '<em><b>Lifelines</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRLifeline}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteractionFragments <em>Interaction Fragments</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lifelines</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lifelines</em>' reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_Lifelines()
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteractionFragments
	 * @model opposite="interactionFragments" required="true"
	 * @generated
	 */
	EList<BVRLifeline> getLifelines();

	/**
	 * Returns the value of the '<em><b>General Orderings</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>General Orderings</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>General Orderings</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_GeneralOrderings()
	 * @model containment="true"
	 * @generated
	 */
	EList<BVRGeneralOrdering> getGeneralOrderings();

	/**
	 * Returns the value of the '<em><b>Messages</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRMessage}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment <em>Interaction Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Messages</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Messages</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_Messages()
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment
	 * @model opposite="interactionFragment" containment="true"
	 * @generated
	 */
	EList<BVRMessage> getMessages();

	/**
	 * Returns the value of the '<em><b>Annotations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.common.CMNAnnotation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Annotations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Annotations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_Annotations()
	 * @model containment="true"
	 * @generated
	 */
	EList<CMNAnnotation> getAnnotations();

	/**
	 * Returns the value of the '<em><b>Interaction</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getInteractionFragments <em>Interaction Fragments</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction</em>' container reference.
	 * @see #setInteraction(BVRInteraction)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_Interaction()
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteraction#getInteractionFragments
	 * @model opposite="interactionFragments"
	 * @generated
	 */
	BVRInteraction getInteraction();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction <em>Interaction</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction</em>' container reference.
	 * @see #getInteraction()
	 * @generated
	 */
	void setInteraction(BVRInteraction value);

	/**
	 * Returns the value of the '<em><b>Properties</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRProperty}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Properties</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Properties</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_Properties()
	 * @model containment="true"
	 * @generated
	 */
	EList<BVRProperty> getProperties();

	/**
	 * Returns the value of the '<em><b>Default Application</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication#getInteractionFragment <em>Interaction Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Application</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Application</em>' containment reference.
	 * @see #setDefaultApplication(TPFDefaultApplication)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRInteractionFragment_DefaultApplication()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication#getInteractionFragment
	 * @model opposite="interactionFragment" containment="true"
	 * @generated
	 */
	TPFDefaultApplication getDefaultApplication();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getDefaultApplication <em>Default Application</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Application</em>' containment reference.
	 * @see #getDefaultApplication()
	 * @generated
	 */
	void setDefaultApplication(TPFDefaultApplication value);

} // BVRInteractionFragment
