/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRMessageSort.java,v 1.8 2009/05/05 15:46:20 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>BVR Message Sort</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The MessageSort captures the different kind of messages that can be used in an Interaction.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessageSort()
 * @model
 * @generated
 */
public enum BVRMessageSort implements Enumerator
{
	/**
	 * The '<em><b>Synch Call</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Synch Call</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SYNCH_CALL
	 * @generated
	 * @ordered
	 */
	SYNCH_CALL_LITERAL(0, "synchCall", "synchCall"),
	/**
	 * The '<em><b>Synch Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Synch Signal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SYNCH_SIGNAL
	 * @generated
	 * @ordered
	 */
	SYNCH_SIGNAL_LITERAL(1, "synchSignal", "synchSignal"),
	/**
	 * The '<em><b>Asynch Call</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Asynch Call</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASYNCH_CALL
	 * @generated
	 * @ordered
	 */
	ASYNCH_CALL_LITERAL(2, "asynchCall", "asynchCall"),
	/**
	 * The '<em><b>Asynch Signal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Asynch Signal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASYNCH_SIGNAL
	 * @generated
	 * @ordered
	 */
	ASYNCH_SIGNAL_LITERAL(3, "asynchSignal", "asynchSignal");
	/**
	 * The '<em><b>Synch Call</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SYNCH_CALL_LITERAL
	 * @model name="synchCall"
	 * @generated
	 * @ordered
	 */
	public static final int SYNCH_CALL = 0;

	/**
	 * The '<em><b>Synch Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SYNCH_SIGNAL_LITERAL
	 * @model name="synchSignal"
	 * @generated
	 * @ordered
	 */
	public static final int SYNCH_SIGNAL = 1;

	/**
	 * The '<em><b>Asynch Call</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASYNCH_CALL_LITERAL
	 * @model name="asynchCall"
	 * @generated
	 * @ordered
	 */
	public static final int ASYNCH_CALL = 2;

	/**
	 * The '<em><b>Asynch Signal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASYNCH_SIGNAL_LITERAL
	 * @model name="asynchSignal"
	 * @generated
	 * @ordered
	 */
	public static final int ASYNCH_SIGNAL = 3;

	/**
	 * An array of all the '<em><b>BVR Message Sort</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final BVRMessageSort[] VALUES_ARRAY =
		new BVRMessageSort[] {
			SYNCH_CALL_LITERAL,
			SYNCH_SIGNAL_LITERAL,
			ASYNCH_CALL_LITERAL,
			ASYNCH_SIGNAL_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>BVR Message Sort</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<BVRMessageSort> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>BVR Message Sort</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static BVRMessageSort get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			BVRMessageSort result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>BVR Message Sort</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static BVRMessageSort getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			BVRMessageSort result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>BVR Message Sort</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static BVRMessageSort get(int value) {
		switch (value) {
			case SYNCH_CALL: return SYNCH_CALL_LITERAL;
			case SYNCH_SIGNAL: return SYNCH_SIGNAL_LITERAL;
			case ASYNCH_CALL: return ASYNCH_CALL_LITERAL;
			case ASYNCH_SIGNAL: return ASYNCH_SIGNAL_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private BVRMessageSort(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

	/**
	 * Returns the enumeration value associated with a 
	 * label.
	 * 
	 * <p>If the label is not valid then this method
	 * returns the default value for the enumeration.
	 * 
	 * @param label
	 * @return BVRMessageSort
	 */
	public static BVRMessageSort getByLabel(String label)
	{
		if(label != null)
		{
			for (int i = 0, maxi=VALUES_ARRAY.length; i < maxi; i++)
			{
				if(label.equals(VALUES_ARRAY[i].getLabel()))
					return VALUES_ARRAY[i];
			}
		}
		return get(label);	
	}

	private final String keyPrefix = getClass().getName() + ".";

	/**
	 * Returns the label associated with this enumeration value.  If
	 * there is no label then this method returns the enumeration's name.
	 * @return String
	 */
	public String getLabel()
	{
		try
		{
			String label = getString(keyPrefix + getName());
			if(label != null)
				return label;
		}
		catch(MissingResourceException e)
		{
		} 

		return getName();
	}

	/**
	 * Returns the string value associated with a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	protected String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return ModelsPlugin.getPlugin().getString(key);
	}
}
