/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVREventOccurrenceImpl.java,v 1.9 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.interactions.BVREventOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Event Occurrence</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl#getTargetGeneralOrderings <em>Target General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl#getSourceGeneralOrderings <em>Source General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl#getFinishExecutionOccurrence <em>Finish Execution Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl#getStartExecutionOcurrence <em>Start Execution Ocurrence</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVREventOccurrenceImpl extends BVRInteractionFragmentImpl implements BVREventOccurrence
{
	/**
	 * The cached value of the '{@link #getTargetGeneralOrderings() <em>Target General Orderings</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetGeneralOrderings()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGeneralOrdering> targetGeneralOrderings;

	/**
	 * The cached value of the '{@link #getSourceGeneralOrderings() <em>Source General Orderings</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceGeneralOrderings()
	 * @generated
	 * @ordered
	 */
	protected EList<BVRGeneralOrdering> sourceGeneralOrderings;

	/**
	 * The cached value of the '{@link #getFinishExecutionOccurrence() <em>Finish Execution Occurrence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFinishExecutionOccurrence()
	 * @generated
	 * @ordered
	 */
	protected BVRExecutionOccurrence finishExecutionOccurrence;

	/**
	 * The cached value of the '{@link #getStartExecutionOcurrence() <em>Start Execution Ocurrence</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartExecutionOcurrence()
	 * @generated
	 * @ordered
	 */
	protected BVRExecutionOccurrence startExecutionOcurrence;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVREventOccurrenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_InteractionsPackage.Literals.BVR_EVENT_OCCURRENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGeneralOrdering> getTargetGeneralOrderings() {
		if (targetGeneralOrderings == null) {
			targetGeneralOrderings = new EObjectWithInverseResolvingEList<BVRGeneralOrdering>(BVRGeneralOrdering.class, this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS, Common_Behavior_InteractionsPackage.BVR_GENERAL_ORDERING__PREVIOUS_EVENT_OCCURRENCE);
		}
		return targetGeneralOrderings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BVRGeneralOrdering> getSourceGeneralOrderings() {
		if (sourceGeneralOrderings == null) {
			sourceGeneralOrderings = new EObjectWithInverseResolvingEList<BVRGeneralOrdering>(BVRGeneralOrdering.class, this, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS, Common_Behavior_InteractionsPackage.BVR_GENERAL_ORDERING__NEXT_EVENT_OCCURENCE);
		}
		return sourceGeneralOrderings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRExecutionOccurrence getFinishExecutionOccurrence() {
		if (finishExecutionOccurrence != null && finishExecutionOccurrence.eIsProxy()) {
			InternalEObject oldFinishExecutionOccurrence = (InternalEObject)finishExecutionOccurrence;
			finishExecutionOccurrence = (BVRExecutionOccurrence)eResolveProxy(oldFinishExecutionOccurrence);
			if (finishExecutionOccurrence != oldFinishExecutionOccurrence) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, oldFinishExecutionOccurrence, finishExecutionOccurrence));
			}
		}
		return finishExecutionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRExecutionOccurrence basicGetFinishExecutionOccurrence() {
		return finishExecutionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFinishExecutionOccurrence(BVRExecutionOccurrence newFinishExecutionOccurrence, NotificationChain msgs) {
		BVRExecutionOccurrence oldFinishExecutionOccurrence = finishExecutionOccurrence;
		finishExecutionOccurrence = newFinishExecutionOccurrence;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, oldFinishExecutionOccurrence, newFinishExecutionOccurrence);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinishExecutionOccurrence(BVRExecutionOccurrence newFinishExecutionOccurrence) {
		if (newFinishExecutionOccurrence != finishExecutionOccurrence) {
			NotificationChain msgs = null;
			if (finishExecutionOccurrence != null)
				msgs = ((InternalEObject)finishExecutionOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
			if (newFinishExecutionOccurrence != null)
				msgs = ((InternalEObject)newFinishExecutionOccurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
			msgs = basicSetFinishExecutionOccurrence(newFinishExecutionOccurrence, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE, newFinishExecutionOccurrence, newFinishExecutionOccurrence));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRExecutionOccurrence getStartExecutionOcurrence() {
		if (startExecutionOcurrence != null && startExecutionOcurrence.eIsProxy()) {
			InternalEObject oldStartExecutionOcurrence = (InternalEObject)startExecutionOcurrence;
			startExecutionOcurrence = (BVRExecutionOccurrence)eResolveProxy(oldStartExecutionOcurrence);
			if (startExecutionOcurrence != oldStartExecutionOcurrence) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, oldStartExecutionOcurrence, startExecutionOcurrence));
			}
		}
		return startExecutionOcurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRExecutionOccurrence basicGetStartExecutionOcurrence() {
		return startExecutionOcurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStartExecutionOcurrence(BVRExecutionOccurrence newStartExecutionOcurrence, NotificationChain msgs) {
		BVRExecutionOccurrence oldStartExecutionOcurrence = startExecutionOcurrence;
		startExecutionOcurrence = newStartExecutionOcurrence;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, oldStartExecutionOcurrence, newStartExecutionOcurrence);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartExecutionOcurrence(BVRExecutionOccurrence newStartExecutionOcurrence) {
		if (newStartExecutionOcurrence != startExecutionOcurrence) {
			NotificationChain msgs = null;
			if (startExecutionOcurrence != null)
				msgs = ((InternalEObject)startExecutionOcurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
			if (newStartExecutionOcurrence != null)
				msgs = ((InternalEObject)newStartExecutionOcurrence).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
			msgs = basicSetStartExecutionOcurrence(newStartExecutionOcurrence, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE, newStartExecutionOcurrence, newStartExecutionOcurrence));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTargetGeneralOrderings()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getSourceGeneralOrderings()).basicAdd(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				if (finishExecutionOccurrence != null)
					msgs = ((InternalEObject)finishExecutionOccurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
				return basicSetFinishExecutionOccurrence((BVRExecutionOccurrence)otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				if (startExecutionOcurrence != null)
					msgs = ((InternalEObject)startExecutionOcurrence).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE, BVRExecutionOccurrence.class, msgs);
				return basicSetStartExecutionOcurrence((BVRExecutionOccurrence)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				return ((InternalEList<?>)getTargetGeneralOrderings()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				return ((InternalEList<?>)getSourceGeneralOrderings()).basicRemove(otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				return basicSetFinishExecutionOccurrence(null, msgs);
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				return basicSetStartExecutionOcurrence(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				return getTargetGeneralOrderings();
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				return getSourceGeneralOrderings();
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				if (resolve) return getFinishExecutionOccurrence();
				return basicGetFinishExecutionOccurrence();
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				if (resolve) return getStartExecutionOcurrence();
				return basicGetStartExecutionOcurrence();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				getTargetGeneralOrderings().clear();
				getTargetGeneralOrderings().addAll((Collection<? extends BVRGeneralOrdering>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				getSourceGeneralOrderings().clear();
				getSourceGeneralOrderings().addAll((Collection<? extends BVRGeneralOrdering>)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				setFinishExecutionOccurrence((BVRExecutionOccurrence)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				setStartExecutionOcurrence((BVRExecutionOccurrence)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				getTargetGeneralOrderings().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				getSourceGeneralOrderings().clear();
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				setFinishExecutionOccurrence((BVRExecutionOccurrence)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				setStartExecutionOcurrence((BVRExecutionOccurrence)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS:
				return targetGeneralOrderings != null && !targetGeneralOrderings.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS:
				return sourceGeneralOrderings != null && !sourceGeneralOrderings.isEmpty();
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE:
				return finishExecutionOccurrence != null;
			case Common_Behavior_InteractionsPackage.BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE:
				return startExecutionOcurrence != null;
		}
		return super.eIsSet(featureID);
	}

} //BVREventOccurrenceImpl
