/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: BVRMessageEndImpl.java,v 1.9 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.configuration.CFGOperation;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.interactions.BVRMessage;
import org.eclipse.hyades.models.common.interactions.BVRMessageEnd;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Message End</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl#getReceiveMessage <em>Receive Message</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl#getSendMessage <em>Send Message</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BVRMessageEndImpl extends BVREventOccurrenceImpl implements BVRMessageEnd
{
	/**
	 * The cached value of the '{@link #getReceiveMessage() <em>Receive Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReceiveMessage()
	 * @generated
	 * @ordered
	 */
	protected BVRMessage receiveMessage;

	/**
	 * The cached value of the '{@link #getSendMessage() <em>Send Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSendMessage()
	 * @generated
	 * @ordered
	 */
	protected BVRMessage sendMessage;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRMessageEndImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_Behavior_InteractionsPackage.Literals.BVR_MESSAGE_END;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRMessage getReceiveMessage() {
		if (receiveMessage != null && receiveMessage.eIsProxy()) {
			InternalEObject oldReceiveMessage = (InternalEObject)receiveMessage;
			receiveMessage = (BVRMessage)eResolveProxy(oldReceiveMessage);
			if (receiveMessage != oldReceiveMessage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, oldReceiveMessage, receiveMessage));
			}
		}
		return receiveMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRMessage basicGetReceiveMessage() {
		return receiveMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReceiveMessage(BVRMessage newReceiveMessage, NotificationChain msgs) {
		BVRMessage oldReceiveMessage = receiveMessage;
		receiveMessage = newReceiveMessage;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, oldReceiveMessage, newReceiveMessage);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReceiveMessage(BVRMessage newReceiveMessage) {
		if (newReceiveMessage != receiveMessage) {
			NotificationChain msgs = null;
			if (receiveMessage != null)
				msgs = ((InternalEObject)receiveMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
			if (newReceiveMessage != null)
				msgs = ((InternalEObject)newReceiveMessage).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
			msgs = basicSetReceiveMessage(newReceiveMessage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE, newReceiveMessage, newReceiveMessage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRMessage getSendMessage() {
		if (sendMessage != null && sendMessage.eIsProxy()) {
			InternalEObject oldSendMessage = (InternalEObject)sendMessage;
			sendMessage = (BVRMessage)eResolveProxy(oldSendMessage);
			if (sendMessage != oldSendMessage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, oldSendMessage, sendMessage));
			}
		}
		return sendMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRMessage basicGetSendMessage() {
		return sendMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSendMessage(BVRMessage newSendMessage, NotificationChain msgs) {
		BVRMessage oldSendMessage = sendMessage;
		sendMessage = newSendMessage;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, oldSendMessage, newSendMessage);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSendMessage(BVRMessage newSendMessage) {
		if (newSendMessage != sendMessage) {
			NotificationChain msgs = null;
			if (sendMessage != null)
				msgs = ((InternalEObject)sendMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
			if (newSendMessage != null)
				msgs = ((InternalEObject)newSendMessage).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
			msgs = basicSetSendMessage(newSendMessage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE, newSendMessage, newSendMessage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				if (receiveMessage != null)
					msgs = ((InternalEObject)receiveMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__RECEIVE_MESSAGE_END, BVRMessage.class, msgs);
				return basicSetReceiveMessage((BVRMessage)otherEnd, msgs);
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				if (sendMessage != null)
					msgs = ((InternalEObject)sendMessage).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_MESSAGE__SEND_MESSAGE_END, BVRMessage.class, msgs);
				return basicSetSendMessage((BVRMessage)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				return basicSetReceiveMessage(null, msgs);
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				return basicSetSendMessage(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				if (resolve) return getReceiveMessage();
				return basicGetReceiveMessage();
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				if (resolve) return getSendMessage();
				return basicGetSendMessage();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				setReceiveMessage((BVRMessage)newValue);
				return;
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				setSendMessage((BVRMessage)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				setReceiveMessage((BVRMessage)null);
				return;
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				setSendMessage((BVRMessage)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__RECEIVE_MESSAGE:
				return receiveMessage != null;
			case Common_Behavior_InteractionsPackage.BVR_MESSAGE_END__SEND_MESSAGE:
				return sendMessage != null;
		}
		return super.eIsSet(featureID);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#getTarget()
	 */
	public IDeployableComponent getTarget() {
		CFGOperationImpl operation = (CFGOperationImpl)getInvocation();
		if ( operation != null )
		{
			return (CFGClassImpl) operation.getOwningClass();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#getInvocation()
	 */
	public IMethod getInvocation() {
		BVRMessageImpl msg = (BVRMessageImpl) getMessages().get(0); 
		if ( msg != null )
		{
			CFGOperation operation = msg.getOperation();
			return (CFGOperationImpl) operation;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation#setInvocation(org.eclipse.hyades.models.common.facades.behavioral.IMethod)
	 */
	public void setInvocation(IMethod method)
	{
		if(method == null)
		{
			if(!getMessages().isEmpty())
			{
				BVRMessage msg = (BVRMessage)getMessages().get(0);
				msg.setOperation(null);
			}
		}
		else
		{
			associateOperationToMessageEnd(method, method.getDeployableComponent());
		}
	}
	
	public void associateOperationToMessageEnd(IMethod method, IDeployableComponent component) 
	{
		BVRMessage msg = null;
		if(getMessages().isEmpty())
		{
			msg = Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRMessage();
			getMessages().add(msg);
		}
		else
			msg = (BVRMessage)getMessages().get(0);
		msg.setOperation((CFGOperationImpl)method);
		
		if(component != null)
		{
			CFGClassImpl cls = (CFGClassImpl)component;
			if(!cls.getInstances().isEmpty())
				getLifelines().add(((CFGInstanceImpl)cls.getInstances().get(0)).getLifeline());
		}			
	}
	
	public void associateOperationToMessageEnd(
		IMethod method)
	{
		// Create a Message
		BVRMessageImpl msg = (BVRMessageImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRMessage();
		msg.setOperation((CFGOperationImpl)method);

		// TODO: May need to rework in future release if assumptions become false.
		
		// Associate the message with the messagend's message collection (assert only 1 for now)
		// ASSUMPTION: We are using only one message end to represent the message
		this.getMessages().add(msg);		
	}
	
	// TODO: These overrided methods need to be reworked in a future release
	public static final String SYNCHRONIZATION_FLAG = "SYNCRONIZATION_FLAG";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#isSynchronous()
	 */
	public boolean isSynchronous() {
		Iterator iter = getProperties().iterator();
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				return Boolean.valueOf(property.getValue()).booleanValue();
			}
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAction#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous)
		throws UnsupportedOperationException 
	{
		Iterator iter = getProperties().iterator();
		// find the synchronization property and set it
		while(iter.hasNext())
		{
			BVRPropertyImpl property = (BVRPropertyImpl)iter.next();
			if(property.getName().equals(SYNCHRONIZATION_FLAG))
			{
				property.setValue(new Boolean(synchronous).toString());
				return;
			}
		}
		// if the property doesn't exist, create it and set it
		BVRPropertyImpl property = (BVRPropertyImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRProperty();
		property.setName(SYNCHRONIZATION_FLAG);
		property.setValue(String.valueOf(synchronous));
		List properties = getProperties();
		properties.add(property);
	}
} //BVRMessageEndImpl
