/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_Behavior_InteractionsAdapterFactory.java,v 1.10 2009/05/05 15:51:28 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.interactions.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.interactions.BVREventOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.BVRMessage;
import org.eclipse.hyades.models.common.interactions.BVRMessageEnd;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.BVRStateInvariant;
import org.eclipse.hyades.models.common.interactions.BVRStop;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage
 * @generated
 */
public class Common_Behavior_InteractionsAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_Behavior_InteractionsPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_Behavior_InteractionsAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = Common_Behavior_InteractionsPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Common_Behavior_InteractionsSwitch<Adapter> modelSwitch =
		new Common_Behavior_InteractionsSwitch<Adapter>() {
			@Override
			public Adapter caseBVRLifeline(BVRLifeline object) {
				return createBVRLifelineAdapter();
			}
			@Override
			public Adapter caseBVRInteractionFragment(BVRInteractionFragment object) {
				return createBVRInteractionFragmentAdapter();
			}
			@Override
			public Adapter caseBVRMessage(BVRMessage object) {
				return createBVRMessageAdapter();
			}
			@Override
			public Adapter caseBVRGeneralOrdering(BVRGeneralOrdering object) {
				return createBVRGeneralOrderingAdapter();
			}
			@Override
			public Adapter caseBVREventOccurrence(BVREventOccurrence object) {
				return createBVREventOccurrenceAdapter();
			}
			@Override
			public Adapter caseBVRMessageEnd(BVRMessageEnd object) {
				return createBVRMessageEndAdapter();
			}
			@Override
			public Adapter caseBVRExecutionOccurrence(BVRExecutionOccurrence object) {
				return createBVRExecutionOccurrenceAdapter();
			}
			@Override
			public Adapter caseBVRStateInvariant(BVRStateInvariant object) {
				return createBVRStateInvariantAdapter();
			}
			@Override
			public Adapter caseBVRStop(BVRStop object) {
				return createBVRStopAdapter();
			}
			@Override
			public Adapter caseBVRProperty(BVRProperty object) {
				return createBVRPropertyAdapter();
			}
			@Override
			public Adapter caseCMNNamedElement(CMNNamedElement object) {
				return createCMNNamedElementAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline <em>BVR Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline
	 * @generated
	 */
	public Adapter createBVRLifelineAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment <em>BVR Interaction Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment
	 * @generated
	 */
	public Adapter createBVRInteractionFragmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRMessage <em>BVR Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage
	 * @generated
	 */
	public Adapter createBVRMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering <em>BVR General Ordering</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering
	 * @generated
	 */
	public Adapter createBVRGeneralOrderingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence <em>BVR Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence
	 * @generated
	 */
	public Adapter createBVREventOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd <em>BVR Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd
	 * @generated
	 */
	public Adapter createBVRMessageEndAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence <em>BVR Execution Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence
	 * @generated
	 */
	public Adapter createBVRExecutionOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRStateInvariant <em>BVR State Invariant</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRStateInvariant
	 * @generated
	 */
	public Adapter createBVRStateInvariantAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRStop <em>BVR Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRStop
	 * @generated
	 */
	public Adapter createBVRStopAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.interactions.BVRProperty <em>BVR Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.interactions.BVRProperty
	 * @generated
	 */
	public Adapter createBVRPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.common.common.CMNNamedElement <em>CMN Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.common.common.CMNNamedElement
	 * @generated
	 */
	public Adapter createCMNNamedElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //Common_Behavior_InteractionsAdapterFactory
