/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFExecutionType.java,v 1.10 2009/05/05 15:46:22 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TPF Execution Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionType()
 * @model
 * @generated
 */
public enum TPFExecutionType implements Enumerator
{
	/**
	 * The '<em><b>Start</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Start</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #START
	 * @generated
	 * @ordered
	 */
	START_LITERAL(0, "start", "start"),
	/**
	 * The '<em><b>Stop</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Stop</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STOP
	 * @generated
	 * @ordered
	 */
	STOP_LITERAL(1, "stop", "stop");
	/**
	 * The '<em><b>Start</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #START_LITERAL
	 * @model name="start"
	 * @generated
	 * @ordered
	 */
	public static final int START = 0;

	/**
	 * The '<em><b>Stop</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STOP_LITERAL
	 * @model name="stop"
	 * @generated
	 * @ordered
	 */
	public static final int STOP = 1;

	/**
	 * An array of all the '<em><b>TPF Execution Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TPFExecutionType[] VALUES_ARRAY =
		new TPFExecutionType[] {
			START_LITERAL,
			STOP_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TPF Execution Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<TPFExecutionType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TPF Execution Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFExecutionType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TPFExecutionType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TPF Execution Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFExecutionType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TPFExecutionType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TPF Execution Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFExecutionType get(int value) {
		switch (value) {
			case START: return START_LITERAL;
			case STOP: return STOP_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TPFExecutionType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

	/**
	 * Returns the enumeration value associated with a 
	 * label.
	 * 
	 * <p>If the label is not valid then this method
	 * returns the default value for the enumeration.
	 * 
	 * @param label
	 * @return TPFExecutionType
	 */
	public static TPFExecutionType getByLabel(String label)
	{
		if(label != null)
		{
			for (int i = 0, maxi=VALUES_ARRAY.length; i < maxi; i++)
			{
				if(label.equals(VALUES_ARRAY[i].getLabel()))
					return VALUES_ARRAY[i];
			}
		}
		return get(label);	
	}

	private final String keyPrefix = getClass().getName() + ".";

	/**
	 * Returns the label associated with this enumeration value.  If
	 * there is no label then this method returns the enumeration's name.
	 * @return String
	 */
	public String getLabel()
	{
		try
		{
			String label = getString(keyPrefix + getName());
			if(label != null)
				return label;
		}
		catch(MissingResourceException e)
		{
		} 

		return getName();
	}

	/**
	 * Returns the string value associated with a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	protected String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return ModelsPlugin.getPlugin().getString(key);
	}
}
