/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFInstanceValue.java,v 1.9 2009/05/05 15:49:17 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.common.CMNNamedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Instance Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An Instance Value is a specification of a named attribute value. The value can take several forms including literal values, expressions, existing InstanceValues, or constraints.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFInstanceValue#getLiteralAny <em>Literal Any</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFInstanceValue#getLiteralAnyOrNull <em>Literal Any Or Null</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFInstanceValue#getCoding <em>Coding</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFInstanceValue()
 * @model
 * @generated
 */
public interface TPFInstanceValue extends CMNNamedElement{
	/**
	 * Returns the value of the '<em><b>Literal Any</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFLiteralAny}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFLiteralAny#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Literal Any</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Literal Any</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFInstanceValue_LiteralAny()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFLiteralAny#getValue
	 * @model opposite="value"
	 * @generated
	 */
	EList<TPFLiteralAny> getLiteralAny();

	/**
	 * Returns the value of the '<em><b>Literal Any Or Null</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFLiteralAnyorNull}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFLiteralAnyorNull#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Literal Any Or Null</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Literal Any Or Null</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFInstanceValue_LiteralAnyOrNull()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFLiteralAnyorNull#getValue
	 * @model opposite="value"
	 * @generated
	 */
	EList<TPFLiteralAnyorNull> getLiteralAnyOrNull();

	/**
	 * Returns the value of the '<em><b>Coding</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFCodingRule}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFCodingRule#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Coding</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Coding</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFInstanceValue_Coding()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFCodingRule#getValue
	 * @model opposite="value" required="true"
	 * @generated
	 */
	EList<TPFCodingRule> getCoding();

} // TPFInstanceValue
