/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFTestCase.java,v 1.9 2009/05/05 15:46:22 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;


import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Test Case</b></em>'.
 * @extends ITestCase
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A test case is a specification of one case to test the system, including what to test with which input, result, and under which conditions.
 * 
 * A test case belongs to a test suite. It has a behavior specifying how a set of cooperating test components interacting with a system under test realize a test objective.
 * 
 * It may invoke other test cases. 
 * 
 * A test case uses an arbiter to evaluate the outcome of its test behavior. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestCase#getTestSuite <em>Test Suite</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestCase#getInstances <em>Instances</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestCase()
 * @model
 * @generated
 */
public interface TPFTestCase extends TPFTest, ITestCase{
	/**
	 * Returns the value of the '<em><b>Test Suite</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getTestCases <em>Test Cases</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Suite</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Suite</em>' container reference.
	 * @see #setTestSuite(TPFTestSuite)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestCase_TestSuite()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getTestCases
	 * @model opposite="testCases" required="true"
	 * @generated
	 */
	TPFTestSuite getTestSuite();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestCase#getTestSuite <em>Test Suite</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Test Suite</em>' container reference.
	 * @see #getTestSuite()
	 * @generated
	 */
	void setTestSuite(TPFTestSuite value);

	/**
	 * Returns the value of the '<em><b>Instances</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGInstance}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase <em>Test Case</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instances</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instances</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestCase_Instances()
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase
	 * @model opposite="testCase" containment="true"
	 * @generated
	 */
	EList<CFGInstance> getInstances();

} // TPFTestCase
