/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFTestComponent.java,v 1.9 2009/05/05 15:49:17 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Test Component</b></em>'.
 * @extends ITestComponent
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A test component is commonly an active class used to specify test cases as interactions between a number of test components with the SUT. The behavior of a test component can be used to specify low level test behavior, or it can be automatically derived from all the test cases behaviors in which the component takes part.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getBehaviors <em>Behaviors</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getTestSuite <em>Test Suite</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getDatapools <em>Datapools</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestComponent()
 * @model
 * @generated
 */
public interface TPFTestComponent extends CFGClass, ITestComponent{
	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestComponent_Type()
	 * @model
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Behaviors</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFBehavior}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTestComponent <em>Test Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Behaviors</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Behaviors</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestComponent_Behaviors()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFBehavior#getTestComponent
	 * @model opposite="testComponent" containment="true" required="true"
	 * @generated
	 */
	EList<TPFBehavior> getBehaviors();

	/**
	 * Returns the value of the '<em><b>Test Suite</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getTestComponents <em>Test Components</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Suite</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Suite</em>' container reference.
	 * @see #setTestSuite(TPFTestSuite)
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestComponent_TestSuite()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getTestComponents
	 * @model opposite="testComponents"
	 * @generated
	 */
	TPFTestSuite getTestSuite();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFTestComponent#getTestSuite <em>Test Suite</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Test Suite</em>' container reference.
	 * @see #getTestSuite()
	 * @generated
	 */
	void setTestSuite(TPFTestSuite value);

	/**
	 * Returns the value of the '<em><b>Datapools</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.datapool.DPLDatapool}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Datapools</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Datapools</em>' reference list.
	 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFTestComponent_Datapools()
	 * @model
	 * @generated
	 */
	EList<DPLDatapool> getDatapools();

} // TPFTestComponent
