/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFVerdict.java,v 1.12 2009/05/05 15:49:17 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TPF Verdict</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The verdict is a predefined enumeration datatype which contains at least the values fail, inconclusive, pass, error indicating how this test case execution has performed. 
 * 
 * - A pass verdict indicates that the test case is successful and that the SUT has behaved according to what should be expected. 
 * - A fail verdict on the other hand shows that the SUT is not behaving according to the specification. 
 * - An inconclusive verdict means that the test execution cannot determine whether the SUT performs well or not. 
 * - An error verdict tells that the test system itself and not the SUT fails.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFVerdict()
 * @model
 * @generated
 */
public enum TPFVerdict implements Enumerator
{
	/**
	 * The '<em><b>Inconclusive</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Inconclusive</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INCONCLUSIVE
	 * @generated
	 * @ordered
	 */
	INCONCLUSIVE_LITERAL(0, "inconclusive", "inconclusive"),
	/**
	 * The '<em><b>Pass</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Pass</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PASS
	 * @generated
	 * @ordered
	 */
	PASS_LITERAL(1, "pass", "pass"),
	/**
	 * The '<em><b>Fail</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Fail</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FAIL
	 * @generated
	 * @ordered
	 */
	FAIL_LITERAL(2, "fail", "fail"),
	/**
	 * The '<em><b>Error</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Error</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ERROR
	 * @generated
	 * @ordered
	 */
	ERROR_LITERAL(3, "error", "error");
	/**
	 * The '<em><b>Inconclusive</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INCONCLUSIVE_LITERAL
	 * @model name="inconclusive"
	 * @generated
	 * @ordered
	 */
	public static final int INCONCLUSIVE = 0;

	/**
	 * The '<em><b>Pass</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PASS_LITERAL
	 * @model name="pass"
	 * @generated
	 * @ordered
	 */
	public static final int PASS = 1;

	/**
	 * The '<em><b>Fail</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FAIL_LITERAL
	 * @model name="fail"
	 * @generated
	 * @ordered
	 */
	public static final int FAIL = 2;

	/**
	 * The '<em><b>Error</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ERROR_LITERAL
	 * @model name="error"
	 * @generated
	 * @ordered
	 */
	public static final int ERROR = 3;

	/**
	 * An array of all the '<em><b>TPF Verdict</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TPFVerdict[] VALUES_ARRAY =
		new TPFVerdict[] {
			INCONCLUSIVE_LITERAL,
			PASS_LITERAL,
			FAIL_LITERAL,
			ERROR_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TPF Verdict</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<TPFVerdict> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TPF Verdict</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFVerdict get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TPFVerdict result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TPF Verdict</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFVerdict getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TPFVerdict result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TPF Verdict</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TPFVerdict get(int value) {
		switch (value) {
			case INCONCLUSIVE: return INCONCLUSIVE_LITERAL;
			case PASS: return PASS_LITERAL;
			case FAIL: return FAIL_LITERAL;
			case ERROR: return ERROR_LITERAL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TPFVerdict(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

	/**
	 * Returns the enumeration value associated with a 
	 * label.
	 * 
	 * <p>If the label is not valid then this method
	 * returns the default value for the enumeration.
	 * 
	 * @param label
	 * @return TPFVerdict
	 */
	public static TPFVerdict getByLabel(String label)
	{
		if(label != null)
		{
			for (int i = 0, maxi=VALUES_ARRAY.length; i < maxi; i++)
			{
				if(label.equals(VALUES_ARRAY[i].getLabel()))
					return VALUES_ARRAY[i];
			}
		}
		return get(label);	
	}

	private final String keyPrefix = getClass().getName() + ".";

	/**
	 * Returns the label associated with this enumeration value.  If
	 * there is no label then this method returns the enumeration's name.
	 * @return String
	 */
	public String getLabel()
	{
		try
		{
			String label = getString(keyPrefix + getName());
			if(label != null)
				return label;
		}
		catch(MissingResourceException e)
		{
		} 

		return getName();
	}

	/**
	 * Returns the string value associated with a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	protected String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return ModelsPlugin.getPlugin().getString(key);
	}
}
