/*******************************************************************************
 * Copyright (c) 2003, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FacadeUtil.java,v 1.5 2008/01/16 18:24:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.List;

import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestComponent;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FacadeUtil {

	public static final FacadeUtil INSTANCE = new FacadeUtil();

	public CFGClass getType(String type, ITest test)
	{
		ITestSuite testSuite = null;
		if(test instanceof ITestSuite)
		{
			testSuite = (ITestSuite)test;	
		}
		else if(test instanceof ITestCase)
		{
			testSuite = ((ITestCase)test).getOwner();
		}
		
		if(type.equals(testSuite.getName()))
		{
			return (CFGClassImpl)testSuite;
		}	
		List systemUnderTests = testSuite.getISystemsUnderTest();
		for(int i = 0; i < systemUnderTests.size(); i++)
		{
			ISystemUnderTest systemUnderTest = (ISystemUnderTest)systemUnderTests.get(i);
			if(type.equals(systemUnderTest.getName()))
			{
				return (CFGClassImpl)systemUnderTest;
			}
		}
		List stubs = testSuite.getITestComponents();
		for(int i = 0; i < stubs.size(); i++)
		{
			ITestComponent stub = (ITestComponent)stubs.get(i);
			if(type.equals(stub.getName()))
			{
				return (CFGClassImpl)stub;
			}
		}

		// JPT - This mechanism for providing support for standard java
		// primitives and standard java classes was apparently never completed.
		// This is probably good, since EMF references stored in the way this
		// code attempts to store them would be unacceptably fragile (since 
		// we would make EMF references to this JavaTypes.xmi file, which, 
		// unless we generated this xmi file into every workspace, would result
		// in fully qualfied references from test models into the plugins 
		// directory (which will be different for every user.)
		
		// Will open an enhancement request to correctly add this capability to
		// the model.
		
//		Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
//		Map m = reg.getExtensionToFactoryMap();
//		m.put("xmi", new FacadeResourceFactoryImpl());		
//
//		try
//		{
//			ResourceSet predefinedTypes = new ResourceSetImpl();
//			predefinedTypes.getResource(URI.createURI("JavaTypes.xmi"), true);
//			TreeIterator iterator = predefinedTypes.getAllContents();
//			while(iterator.hasNext())
//			{
//				IDeployableComponent typeClass = (IDeployableComponent)iterator.next();
//				if(type.equals(typeClass.getName()))
//				{
//					return (CFGClassImpl)typeClass;	
//				}
//			}
//		}
//		catch(Exception e)
//		{
//			// ignore exception
//		}
			
		return null;
	}


}
