/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFArbiterImpl.java,v 1.12 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Arbiter</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFArbiterImpl#getBehaviors <em>Behaviors</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFArbiterImpl#getTestSuite <em>Test Suite</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFArbiterImpl extends CFGClassImpl implements TPFArbiter
{
	/**
	 * The cached value of the '{@link #getBehaviors() <em>Behaviors</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehaviors()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFBehavior> behaviors;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFArbiterImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_ARBITER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFBehavior> getBehaviors() {
		if (behaviors == null) {
			behaviors = new EObjectContainmentWithInverseEList<TPFBehavior>(TPFBehavior.class, this, Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER);
		}
		return behaviors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestSuite getTestSuite() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE) return null;
		return (TPFTestSuite)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTestSuite(TPFTestSuite newTestSuite, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTestSuite, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestSuite(TPFTestSuite newTestSuite) {
		if (newTestSuite != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE && newTestSuite != null)) {
			if (EcoreUtil.isAncestor(this, newTestSuite))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestSuite != null)
				msgs = ((InternalEObject)newTestSuite).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, TPFTestSuite.class, msgs);
			msgs = basicSetTestSuite(newTestSuite, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, newTestSuite, newTestSuite));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getBehaviors()).basicAdd(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTestSuite((TPFTestSuite)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				return ((InternalEList<?>)getBehaviors()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				return basicSetTestSuite(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, TPFTestSuite.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				return getBehaviors();
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				return getTestSuite();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				getBehaviors().clear();
				getBehaviors().addAll((Collection<? extends TPFBehavior>)newValue);
				return;
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				setTestSuite((TPFTestSuite)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				getBehaviors().clear();
				return;
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				setTestSuite((TPFTestSuite)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS:
				return behaviors != null && !behaviors.isEmpty();
			case Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE:
				return getTestSuite() != null;
		}
		return super.eIsSet(featureID);
	}

	private TPFBehavior getDeployableBehavior()
	{
		// This method currently takes the first behavior of the TestComponent, since every
		// behavior should point to the same deployable entity.
		return (TPFBehaviorImpl) behaviors.get(0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public String getLocation() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getLocation();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return (TPFTestSuiteImpl)getTestSuite();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public String getResource() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getResource();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public void setLocation(String location) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setLocation(location);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public void setResource(String resource) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setResource(resource);
		}
	}

} //TPFArbiterImpl
