/**********************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFBehaviorImpl.java,v 1.15 2010/04/12 12:38:40 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Behavior</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getInteraction <em>Interaction</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getIsReentrant <em>Is Reentrant</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getResource <em>Resource</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getArbiter <em>Arbiter</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getTestComponent <em>Test Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFBehaviorImpl extends CMNNamedElementImpl implements TPFBehavior
{
	/**
	 * The cached value of the '{@link #getInteraction() <em>Interaction</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteraction()
	 * @generated
	 * @ordered
	 */
	protected BVRInteraction interaction;

	/**
	 * The default value of the '{@link #getIsReentrant() <em>Is Reentrant</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsReentrant()
	 * @generated
	 * @ordered
	 */
	protected static final Boolean IS_REENTRANT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIsReentrant() <em>Is Reentrant</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsReentrant()
	 * @generated
	 * @ordered
	 */
	protected Boolean isReentrant = IS_REENTRANT_EDEFAULT;

	/**
	 * The default value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResource() <em>Resource</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResource()
	 * @generated
	 * @ordered
	 */
	protected String resource = RESOURCE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected String location = LOCATION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFBehaviorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_BEHAVIOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Boolean getIsReentrant() {
		return isReentrant;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsReentrant(Boolean newIsReentrant) {
		Boolean oldIsReentrant = isReentrant;
		isReentrant = newIsReentrant;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT, oldIsReentrant, isReentrant));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getResource() {
		return resource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResource(String newResource) {
		String oldResource = resource;
		resource = newResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE, oldResource, resource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation) {
		String oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION, oldLocation, location));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteraction getInteraction() {
		return interaction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInteraction(BVRInteraction newInteraction, NotificationChain msgs) {
		BVRInteraction oldInteraction = interaction;
		interaction = newInteraction;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, oldInteraction, newInteraction);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteraction(BVRInteraction newInteraction) {
		if (newInteraction != interaction) {
			NotificationChain msgs = null;
			if (interaction != null)
				msgs = ((InternalEObject)interaction).eInverseRemove(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, BVRInteraction.class, msgs);
			if (newInteraction != null)
				msgs = ((InternalEObject)newInteraction).eInverseAdd(this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, BVRInteraction.class, msgs);
			msgs = basicSetInteraction(newInteraction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, newInteraction, newInteraction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFArbiter getArbiter() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER) return null;
		return (TPFArbiter)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetArbiter(TPFArbiter newArbiter, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newArbiter, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArbiter(TPFArbiter newArbiter) {
		if (newArbiter != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER && newArbiter != null)) {
			if (EcoreUtil.isAncestor(this, newArbiter))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newArbiter != null)
				msgs = ((InternalEObject)newArbiter).eInverseAdd(this, Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS, TPFArbiter.class, msgs);
			msgs = basicSetArbiter(newArbiter, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER, newArbiter, newArbiter));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTestComponent getTestComponent() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT) return null;
		return (TPFTestComponent)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTestComponent(TPFTestComponent newTestComponent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTestComponent, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestComponent(TPFTestComponent newTestComponent) {
		if (newTestComponent != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT && newTestComponent != null)) {
			if (EcoreUtil.isAncestor(this, newTestComponent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTestComponent != null)
				msgs = ((InternalEObject)newTestComponent).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS, TPFTestComponent.class, msgs);
			msgs = basicSetTestComponent(newTestComponent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT, newTestComponent, newTestComponent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTest getTest() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__TEST) return null;
		return (TPFTest)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTest(TPFTest newTest, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newTest, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTest(TPFTest newTest) {
		if (newTest != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_BEHAVIOR__TEST && newTest != null)) {
			if (EcoreUtil.isAncestor(this, newTest))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTest != null)
				msgs = ((InternalEObject)newTest).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, TPFTest.class, msgs);
			msgs = basicSetTest(newTest, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, newTest, newTest));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				if (interaction != null)
					msgs = ((InternalEObject)interaction).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, null, msgs);
				return basicSetInteraction((BVRInteraction)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetArbiter((TPFArbiter)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTestComponent((TPFTestComponent)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetTest((TPFTest)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				return basicSetInteraction(null, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return basicSetArbiter(null, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return basicSetTestComponent(null, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return basicSetTest(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_ARBITER__BEHAVIORS, TPFArbiter.class, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_COMPONENT__BEHAVIORS, TPFTestComponent.class, msgs);
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, TPFTest.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				return getInteraction();
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				return getIsReentrant();
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				return getResource();
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				return getLocation();
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return getArbiter();
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return getTestComponent();
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return getTest();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				setInteraction((BVRInteraction)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				setIsReentrant((Boolean)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				setResource((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				setLocation((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				setArbiter((TPFArbiter)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				setTestComponent((TPFTestComponent)newValue);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				setTest((TPFTest)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				setInteraction((BVRInteraction)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				setIsReentrant(IS_REENTRANT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				setResource(RESOURCE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				setLocation(LOCATION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				setArbiter((TPFArbiter)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				setTestComponent((TPFTestComponent)null);
				return;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				setTest((TPFTest)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION:
				return interaction != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__IS_REENTRANT:
				return IS_REENTRANT_EDEFAULT == null ? isReentrant != null : !IS_REENTRANT_EDEFAULT.equals(isReentrant);
			case Common_TestprofilePackage.TPF_BEHAVIOR__RESOURCE:
				return RESOURCE_EDEFAULT == null ? resource != null : !RESOURCE_EDEFAULT.equals(resource);
			case Common_TestprofilePackage.TPF_BEHAVIOR__LOCATION:
				return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
			case Common_TestprofilePackage.TPF_BEHAVIOR__ARBITER:
				return getArbiter() != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST_COMPONENT:
				return getTestComponent() != null;
			case Common_TestprofilePackage.TPF_BEHAVIOR__TEST:
				return getTest() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (isReentrant: ");
		result.append(isReentrant);
		result.append(", resource: ");
		result.append(resource);
		result.append(", location: ");
		result.append(location);
		result.append(')');
		return result.toString();
	}

	// TODO: This may need to be moved to a utility class in a future release
	public BVRLifelineImpl getSelfLifeline()
	{
		BVRLifelineImpl selfLifeline = null;
		
		// Determine if the owner of the behavior is a TestCase or a TestSuite
		// If the owner is a test case, find the owning test suite so we
		// can determine the CFGDeployable that is associated with the
		// self lifeline.
		ITest test = getOwner();
		
		if ( test != null && interaction != null )
		{
			TPFTestSuite suite;
			if ( test instanceof TPFTestCaseImpl )
			{
				suite = ((TPFTestCaseImpl)test).getTestSuite();
			}
			else if ( test instanceof TPFTestSuiteImpl )
			{
				suite = (TPFTestSuiteImpl) test;
			}
			else
			{
				return null;			
			}
		
			List lifelines = getInteraction().getLifelines();
			if ( !lifelines.isEmpty() )
			{
				Iterator it = lifelines.iterator();
				BVRLifeline lifeline;
				while ( it.hasNext() )
				{
					lifeline = (BVRLifeline) it.next();
					if(!lifeline.getInstances().isEmpty())
					{
						CFGClass deployable = ((CFGInstance)lifeline.getInstances().get(0)).getClassType();
						if ( deployable.equals(suite) )
						{
							selfLifeline = (BVRLifelineImpl) lifeline;
							break;
						}
					}
				}
			
			}
		}
		return selfLifeline;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IImplementor#getBlock()
	 */
	public IBlock getBlock() {
		return (BVRInteractionImpl)getInteraction();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return (ITest)getTest();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getMethods()
	 */
	public List getMethods()
	{
		if(getTest() != null)
		{
			if(getTest() instanceof TPFTestCase)
				return ((TPFTestCase)getTest()).getTestSuite().getOperations();
			
			if(getTest() instanceof TPFTestSuite)
				return ((TPFTestSuite)getTest()).getOperations();
		}
		
		if(getArbiter() != null)
			return getArbiter().getOperations();
			
		if(getTestComponent() != null)
			return getTestComponent().getOperations();
		
		return Collections.unmodifiableList(Collections.EMPTY_LIST);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IImplementor#isExternalImplementor()
	 */
	public boolean isExternalImplementor() {
		if(getBlock() == null)
		{	
			return true;
		}
		else
		{
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getEnvironmentVariables()
	 */
	public IPropertyGroup getEnvironmentVariables() {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IProjectBasedComponent#getProject()
	 */
	public String getProject() {		
		URI uri = getPlatformURI(); 
		if(uri != null && uri.segmentCount() > 1)
			return uri.segment(1);			
				
		return null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IProjectBasedComponent#getPlatformURI()
	 */
	public URI getPlatformURI() {
		if(getLocation() != null)
			return URI.createPlatformResourceURI(getLocation(), false);		
		return null;
	}
} //TPFBehaviorImpl
