/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFDeploymentImpl.java,v 1.11 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.configuration.impl.CFGConfigurableObjectImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Deployment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getLocations <em>Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getRefLocations <em>Ref Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getArtifactLocations <em>Artifact Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getTestSuites <em>Test Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFDeploymentImpl#getArtifacts <em>Artifacts</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFDeploymentImpl extends CFGConfigurableObjectImpl implements TPFDeployment
{
	/**
	 * The cached value of the '{@link #getLocations() <em>Locations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocations()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGLocation> locations;

	/**
	 * The cached value of the '{@link #getRefLocations() <em>Ref Locations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefLocations()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGLocation> refLocations;

	/**
	 * The cached value of the '{@link #getArtifactLocations() <em>Artifact Locations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArtifactLocations()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGArtifactLocationPair> artifactLocations;

	/**
	 * The cached value of the '{@link #getTestSuites() <em>Test Suites</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestSuites()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFTestSuite> testSuites;

	/**
	 * The cached value of the '{@link #getArtifacts() <em>Artifacts</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArtifacts()
	 * @generated
	 * @ordered
	 */
	protected EList<CFGArtifact> artifacts;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFDeploymentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_DEPLOYMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGLocation> getLocations() {
		if (locations == null) {
			locations = new EObjectContainmentWithInverseEList<CFGLocation>(CFGLocation.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT);
		}
		return locations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGLocation> getRefLocations() {
		if (refLocations == null) {
			refLocations = new EObjectResolvingEList<CFGLocation>(CFGLocation.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__REF_LOCATIONS);
		}
		return refLocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGArtifactLocationPair> getArtifactLocations() {
		if (artifactLocations == null) {
			artifactLocations = new EObjectContainmentEList<CFGArtifactLocationPair>(CFGArtifactLocationPair.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS);
		}
		return artifactLocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFTestSuite> getTestSuites() {
		if (testSuites == null) {
			testSuites = new EObjectResolvingEList<TPFTestSuite>(TPFTestSuite.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__TEST_SUITES);
		}
		return testSuites;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CFGArtifact> getArtifacts() {
		if (artifacts == null) {
			artifacts = new EObjectResolvingEList<CFGArtifact>(CFGArtifact.class, this, Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACTS);
		}
		return artifacts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getLocations()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return ((InternalEList<?>)getLocations()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS:
				return ((InternalEList<?>)getArtifactLocations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return getLocations();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__REF_LOCATIONS:
				return getRefLocations();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS:
				return getArtifactLocations();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__TEST_SUITES:
				return getTestSuites();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACTS:
				return getArtifacts();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				getLocations().clear();
				getLocations().addAll((Collection<? extends CFGLocation>)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__REF_LOCATIONS:
				getRefLocations().clear();
				getRefLocations().addAll((Collection<? extends CFGLocation>)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS:
				getArtifactLocations().clear();
				getArtifactLocations().addAll((Collection<? extends CFGArtifactLocationPair>)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__TEST_SUITES:
				getTestSuites().clear();
				getTestSuites().addAll((Collection<? extends TPFTestSuite>)newValue);
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACTS:
				getArtifacts().clear();
				getArtifacts().addAll((Collection<? extends CFGArtifact>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				getLocations().clear();
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__REF_LOCATIONS:
				getRefLocations().clear();
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS:
				getArtifactLocations().clear();
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__TEST_SUITES:
				getTestSuites().clear();
				return;
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACTS:
				getArtifacts().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS:
				return locations != null && !locations.isEmpty();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__REF_LOCATIONS:
				return refLocations != null && !refLocations.isEmpty();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACT_LOCATIONS:
				return artifactLocations != null && !artifactLocations.isEmpty();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__TEST_SUITES:
				return testSuites != null && !testSuites.isEmpty();
			case Common_TestprofilePackage.TPF_DEPLOYMENT__ARTIFACTS:
				return artifacts != null && !artifacts.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TPFDeploymentImpl
