/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFExecutionHistoryImpl.java,v 1.12 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution History</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionHistoryImpl#getExecutionResult <em>Execution Result</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionHistoryImpl#getExecutionEvents <em>Execution Events</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionHistoryImpl extends EObjectImpl implements TPFExecutionHistory
{
	/**
	 * The cached value of the '{@link #getExecutionEvents() <em>Execution Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecutionEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFExecutionEvent> executionEvents;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFExecutionHistoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_EXECUTION_HISTORY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionResult getExecutionResult() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT) return null;
		return (TPFExecutionResult)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExecutionResult(TPFExecutionResult newExecutionResult, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newExecutionResult, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionResult(TPFExecutionResult newExecutionResult) {
		if (newExecutionResult != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT && newExecutionResult != null)) {
			if (EcoreUtil.isAncestor(this, newExecutionResult))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newExecutionResult != null)
				msgs = ((InternalEObject)newExecutionResult).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, TPFExecutionResult.class, msgs);
			msgs = basicSetExecutionResult(newExecutionResult, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, newExecutionResult, newExecutionResult));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFExecutionEvent> getExecutionEvents() {
		if (executionEvents == null) {
			executionEvents = new EObjectContainmentWithInverseEList<TPFExecutionEvent>(TPFExecutionEvent.class, this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY);
		}
		return executionEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetExecutionResult((TPFExecutionResult)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getExecutionEvents()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				return basicSetExecutionResult(null, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				return ((InternalEList<?>)getExecutionEvents()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, TPFExecutionResult.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				return getExecutionResult();
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				return getExecutionEvents();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				setExecutionResult((TPFExecutionResult)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				getExecutionEvents().clear();
				getExecutionEvents().addAll((Collection<? extends TPFExecutionEvent>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				setExecutionResult((TPFExecutionResult)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				getExecutionEvents().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT:
				return getExecutionResult() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS:
				return executionEvents != null && !executionEvents.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //TPFExecutionHistoryImpl
