/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFExecutionResultImpl.java,v 1.14 2009/05/05 15:49:18 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.EObjectReference;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getTestVersion <em>Test Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getVerdict <em>Verdict</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getDeployment <em>Deployment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getInvocationExecutionEvent <em>Invocation Execution Event</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getTest <em>Test</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getEObjectReferences <em>EObject References</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getVerdictLists <em>Verdict Lists</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionResultImpl#getRecords <em>Records</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionResultImpl extends CMNNamedElementImpl implements TPFExecutionResult
{
	/**
	 * The default value of the '{@link #getTestVersion() <em>Test Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String TEST_VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTestVersion() <em>Test Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTestVersion()
	 * @generated
	 * @ordered
	 */
	protected String testVersion = TEST_VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerdict()
	 * @generated
	 * @ordered
	 */
	protected static final TPFVerdict VERDICT_EDEFAULT = TPFVerdict.INCONCLUSIVE_LITERAL;

	/**
	 * The cached value of the '{@link #getVerdict() <em>Verdict</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerdict()
	 * @generated
	 * @ordered
	 */
	protected TPFVerdict verdict = VERDICT_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDeployment() <em>Deployment</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeployment()
	 * @generated
	 * @ordered
	 */
	protected TPFDeployment deployment;

	/**
	 * The cached value of the '{@link #getExecutionHistory() <em>Execution History</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecutionHistory()
	 * @generated
	 * @ordered
	 */
	protected TPFExecutionHistory executionHistory;

	/**
	 * The cached value of the '{@link #getTest() <em>Test</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTest()
	 * @generated
	 * @ordered
	 */
	protected TPFTest test;

	/**
	 * The cached value of the '{@link #getEObjectReferences() <em>EObject References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEObjectReferences()
	 * @generated
	 * @ordered
	 */
	protected EList<EObjectReference> eObjectReferences;
	
	/**
	 * The cached value of the '{@link #getRecords() <em>Records</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRecords()
	 * @generated
	 * @ordered
	 */
	protected EList<TPFRepositoryRecord> records;

	/**
	 * The cached value of the '{@link #getVerdictLists() <em>Verdict Lists</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVerdictLists()
	 * @generated NOT
	 * @ordered
	 */
	protected EList verdictLists = null;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFExecutionResultImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_EXECUTION_RESULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTestVersion() {
		return testVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestVersion(String newTestVersion) {
		String oldTestVersion = testVersion;
		testVersion = newTestVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION, oldTestVersion, testVersion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFVerdict getVerdict() {
		return verdict;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVerdict(TPFVerdict newVerdict) {
		TPFVerdict oldVerdict = verdict;
		verdict = newVerdict == null ? VERDICT_EDEFAULT : newVerdict;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT, oldVerdict, verdict));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFDeployment getDeployment() {
		if (deployment != null && deployment.eIsProxy()) {
			InternalEObject oldDeployment = (InternalEObject)deployment;
			deployment = (TPFDeployment)eResolveProxy(oldDeployment);
			if (deployment != oldDeployment) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT, oldDeployment, deployment));
			}
		}
		return deployment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFDeployment basicGetDeployment() {
		return deployment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeployment(TPFDeployment newDeployment) {
		TPFDeployment oldDeployment = deployment;
		deployment = newDeployment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT, oldDeployment, deployment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionHistory getExecutionHistory() {
		return executionHistory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExecutionHistory(TPFExecutionHistory newExecutionHistory, NotificationChain msgs) {
		TPFExecutionHistory oldExecutionHistory = executionHistory;
		executionHistory = newExecutionHistory;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, oldExecutionHistory, newExecutionHistory);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionHistory(TPFExecutionHistory newExecutionHistory) {
		if (newExecutionHistory != executionHistory) {
			NotificationChain msgs = null;
			if (executionHistory != null)
				msgs = ((InternalEObject)executionHistory).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, TPFExecutionHistory.class, msgs);
			if (newExecutionHistory != null)
				msgs = ((InternalEObject)newExecutionHistory).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_RESULT, TPFExecutionHistory.class, msgs);
			msgs = basicSetExecutionHistory(newExecutionHistory, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, newExecutionHistory, newExecutionHistory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFInvocationEvent getInvocationExecutionEvent() {
		if (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT) return null;
		return (TPFInvocationEvent)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInvocationExecutionEvent(TPFInvocationEvent newInvocationExecutionEvent, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newInvocationExecutionEvent, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInvocationExecutionEvent(TPFInvocationEvent newInvocationExecutionEvent) {
		if (newInvocationExecutionEvent != eInternalContainer() || (eContainerFeatureID() != Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT && newInvocationExecutionEvent != null)) {
			if (EcoreUtil.isAncestor(this, newInvocationExecutionEvent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newInvocationExecutionEvent != null)
				msgs = ((InternalEObject)newInvocationExecutionEvent).eInverseAdd(this, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, TPFInvocationEvent.class, msgs);
			msgs = basicSetInvocationExecutionEvent(newInvocationExecutionEvent, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT, newInvocationExecutionEvent, newInvocationExecutionEvent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTest getTest() {
		if (test != null && test.eIsProxy()) {
			InternalEObject oldTest = (InternalEObject)test;
			test = (TPFTest)eResolveProxy(oldTest);
			if (test != oldTest) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST, oldTest, test));
			}
		}
		return test;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTest basicGetTest() {
		return test;
	}

	/**
	 * This setter has an additional side effect of setting the this.type to
	 * the same String as newTest.getType()  It delegates the actual setTest work
	 * to the EMF generated setter method (leveraging the EMF naming convention
	 * to xxxGen(), EMF will continue to update the generated method that ends with 
	 * Gen, and will not overwrite this method.)
	 *     
	 * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#setTest(org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setTest(TPFTest newTest) {
		setTestGen(newTest);
		if ( newTest != null && newTest.getType() != null )
		{
			type = newTest.getType();
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTestGen(TPFTest newTest) {
		TPFTest oldTest = test;
		test = newTest;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST, oldTest, test));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EObjectReference> getEObjectReferences() {
		if (eObjectReferences == null) {
			eObjectReferences = new EObjectContainmentEList<EObjectReference>(EObjectReference.class, this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES);
		}
		return eObjectReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList getVerdictLists() {
		if (verdictLists == null) {
			verdictLists = new EObjectContainmentEList(TPFVerdictList.class, this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT_LISTS);
		}
		return verdictLists;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TPFRepositoryRecord> getRecords() {
		if (records == null) {
			records = new EObjectWithInverseResolvingEList<TPFRepositoryRecord>(TPFRepositoryRecord.class, this, Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS, Common_TestprofilePackage.TPF_REPOSITORY_RECORD__EXECUTION_RESULT);
		}
		return records;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				if (executionHistory != null)
					msgs = ((InternalEObject)executionHistory).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY, null, msgs);
				return basicSetExecutionHistory((TPFExecutionHistory)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetInvocationExecutionEvent((TPFInvocationEvent)otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRecords()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				return basicSetExecutionHistory(null, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				return basicSetInvocationExecutionEvent(null, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES:
				return ((InternalEList<?>)getEObjectReferences()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT_LISTS:
				return ((InternalEList<?>)getVerdictLists()).basicRemove(otherEnd, msgs);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				return ((InternalEList<?>)getRecords()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				return eInternalContainer().eInverseRemove(this, Common_TestprofilePackage.TPF_INVOCATION_EVENT__INVOKED_EXECUTION_RESULT, TPFInvocationEvent.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
				return getTestVersion();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
				return getVerdict();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
				return getType();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
				if (resolve) return getDeployment();
				return basicGetDeployment();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				return getExecutionHistory();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				return getInvocationExecutionEvent();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
				if (resolve) return getTest();
				return basicGetTest();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES:
				return getEObjectReferences();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT_LISTS:
				return getVerdictLists();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				return getRecords();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
				setTestVersion((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
				setVerdict((TPFVerdict)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
				setType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
				setDeployment((TPFDeployment)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				setInvocationExecutionEvent((TPFInvocationEvent)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
				setTest((TPFTest)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				getEObjectReferences().addAll((Collection<? extends EObjectReference>)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				getRecords().clear();
				getRecords().addAll((Collection<? extends TPFRepositoryRecord>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
				setTestVersion(TEST_VERSION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
				setVerdict(VERDICT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
				setDeployment((TPFDeployment)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				setInvocationExecutionEvent((TPFInvocationEvent)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
				setTest((TPFTest)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				getRecords().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST_VERSION:
				return TEST_VERSION_EDEFAULT == null ? testVersion != null : !TEST_VERSION_EDEFAULT.equals(testVersion);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT:
				return verdict != VERDICT_EDEFAULT;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__DEPLOYMENT:
				return deployment != null;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EXECUTION_HISTORY:
				return executionHistory != null;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__INVOCATION_EXECUTION_EVENT:
				return getInvocationExecutionEvent() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__TEST:
				return test != null;
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__EOBJECT_REFERENCES:
				return eObjectReferences != null && !eObjectReferences.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__VERDICT_LISTS:
				return !getVerdictLists().isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT__RECORDS:
				return records != null && !records.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (testVersion: ");
		result.append(testVersion);
		result.append(", verdict: ");
		result.append(verdict);
		result.append(", type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

} //TPFExecutionResultImpl
