/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TPFVerdictListImpl.java,v 1.11 2009/05/05 15:49:19 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Verdict List</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFVerdictListImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFVerdictListImpl#getVerdictEvents <em>Verdict Events</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFVerdictListImpl extends EObjectImpl implements TPFVerdictList
{
	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;
	
	/**
	 * The cached value of the '{@link #getVerdictEvents() <em>Verdict Events</em>}' reference list.
	 * 
	 * @see #getVerdictEvents()
	 * @generated NOT
	 */
	protected EList verdictEvents = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFVerdictListImpl() {
		super();
	}

	/**
	 * Instantiate a new verdict list with a type.
	 * @generated NOT
	 */
	protected TPFVerdictListImpl(String verdictType)
	{
		super();
		setType(verdictType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.Literals.TPF_VERDICT_LIST;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_VERDICT_LIST__TYPE, oldType, type));
	}

	/**
	 * Returns the 'Verdict Events' reference list of <code>TPFVerdictEvent</code>.
	 * 
	 * @generated NOT
	 */
	public EList getVerdictEvents()
	{
		if(verdictEvents == null)
		{
			verdictEvents = new EObjectResolvingEList(TPFVerdictEvent.class, this, Common_TestprofilePackage.TPF_VERDICT_LIST__VERDICT_EVENTS) {
				private static final long serialVersionUID = -1032764160447291346L;
				
				// JPT: EObjectResolvingEList by default is a unique  
				// list, because it inherits from EObjectEList.  If isUnique()
				// returns true, then the BasicEList.add() method walks the 
				// entire list to ensure that the new element does not already 
				// exist before adding it.  This makes populating the collection 
				// a O(n^2) operation.  O(n^2) algorithms make puppies cry. 
				protected boolean isUnique() {
					return false;
				}
			};
		}
		
		return verdictEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_LIST__TYPE:
				return getType();
			case Common_TestprofilePackage.TPF_VERDICT_LIST__VERDICT_EVENTS:
				return getVerdictEvents();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
		@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_LIST__TYPE:
				setType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_LIST__VERDICT_EVENTS:
				getVerdictEvents().clear();
				getVerdictEvents().addAll((Collection<? extends TPFVerdictEvent>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_LIST__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_VERDICT_LIST__VERDICT_EVENTS:
				getVerdictEvents().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Common_TestprofilePackage.TPF_VERDICT_LIST__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case Common_TestprofilePackage.TPF_VERDICT_LIST__VERDICT_EVENTS:
				return verdictEvents != null && !verdictEvents.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(')');
		return result.toString();
	}

} //TPFVerdictListImpl
