/**********************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: Common_TestprofileSwitch.java,v 1.13 2009/05/05 15:46:22 paules Exp $
 **********************************************************************/
 
/*
 * generated using TPTP customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.util;

import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.interactions.BVREventOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.EObjectReference;
import org.eclipse.hyades.models.common.testprofile.ITPFExtendedVerdictReason;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFCodingRule;
import org.eclipse.hyades.models.common.testprofile.TPFDefault;
import org.eclipse.hyades.models.common.testprofile.TPFDefaultApplication;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionStatus;
import org.eclipse.hyades.models.common.testprofile.TPFInstanceValue;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLiteralAny;
import org.eclipse.hyades.models.common.testprofile.TPFLiteralAnyorNull;
import org.eclipse.hyades.models.common.testprofile.TPFLogAction;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFRepositoryRecord;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTimezone;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFValidationAction;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictList;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage
 * @generated
 */
public class Common_TestprofileSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static Common_TestprofilePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Common_TestprofileSwitch() {
		if (modelPackage == null) {
			modelPackage = Common_TestprofilePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case Common_TestprofilePackage.TPF_DEPLOYMENT: {
				TPFDeployment tpfDeployment = (TPFDeployment)theEObject;
				T result = caseTPFDeployment(tpfDeployment);
				if (result == null) result = caseCFGConfigurableObject(tpfDeployment);
				if (result == null) result = caseCMNNamedElement(tpfDeployment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_LITERAL_ANYOR_NULL: {
				TPFLiteralAnyorNull tpfLiteralAnyorNull = (TPFLiteralAnyorNull)theEObject;
				T result = caseTPFLiteralAnyorNull(tpfLiteralAnyorNull);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_LITERAL_ANY: {
				TPFLiteralAny tpfLiteralAny = (TPFLiteralAny)theEObject;
				T result = caseTPFLiteralAny(tpfLiteralAny);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_INSTANCE_VALUE: {
				TPFInstanceValue tpfInstanceValue = (TPFInstanceValue)theEObject;
				T result = caseTPFInstanceValue(tpfInstanceValue);
				if (result == null) result = caseCMNNamedElement(tpfInstanceValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_EXECUTION_RESULT: {
				TPFExecutionResult tpfExecutionResult = (TPFExecutionResult)theEObject;
				T result = caseTPFExecutionResult(tpfExecutionResult);
				if (result == null) result = caseCMNNamedElement(tpfExecutionResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_LOG_ACTION: {
				TPFLogAction tpfLogAction = (TPFLogAction)theEObject;
				T result = caseTPFLogAction(tpfLogAction);
				if (result == null) result = caseBVREventOccurrence(tpfLogAction);
				if (result == null) result = caseBVRInteractionFragment(tpfLogAction);
				if (result == null) result = caseCMNNamedElement(tpfLogAction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_DEFAULT: {
				TPFDefault tpfDefault = (TPFDefault)theEObject;
				T result = caseTPFDefault(tpfDefault);
				if (result == null) result = caseTPFBehavior(tpfDefault);
				if (result == null) result = caseCMNNamedElement(tpfDefault);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_DEFAULT_APPLICATION: {
				TPFDefaultApplication tpfDefaultApplication = (TPFDefaultApplication)theEObject;
				T result = caseTPFDefaultApplication(tpfDefaultApplication);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_BEHAVIOR: {
				TPFBehavior tpfBehavior = (TPFBehavior)theEObject;
				T result = caseTPFBehavior(tpfBehavior);
				if (result == null) result = caseCMNNamedElement(tpfBehavior);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TEST_CASE: {
				TPFTestCase tpfTestCase = (TPFTestCase)theEObject;
				T result = caseTPFTestCase(tpfTestCase);
				if (result == null) result = caseTPFTest(tpfTestCase);
				if (result == null) result = caseCMNNamedElement(tpfTestCase);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_ARBITER: {
				TPFArbiter tpfArbiter = (TPFArbiter)theEObject;
				T result = caseTPFArbiter(tpfArbiter);
				if (result == null) result = caseCFGClass(tpfArbiter);
				if (result == null) result = caseCMNNamedElement(tpfArbiter);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_CODING_RULE: {
				TPFCodingRule tpfCodingRule = (TPFCodingRule)theEObject;
				T result = caseTPFCodingRule(tpfCodingRule);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPFSUT: {
				TPFSUT tpfsut = (TPFSUT)theEObject;
				T result = caseTPFSUT(tpfsut);
				if (result == null) result = caseCFGClass(tpfsut);
				if (result == null) result = caseCMNNamedElement(tpfsut);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TEST_SUITE: {
				TPFTestSuite tpfTestSuite = (TPFTestSuite)theEObject;
				T result = caseTPFTestSuite(tpfTestSuite);
				if (result == null) result = caseCFGClass(tpfTestSuite);
				if (result == null) result = caseTPFTest(tpfTestSuite);
				if (result == null) result = caseCMNNamedElement(tpfTestSuite);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TEST_OBJECTIVE: {
				TPFTestObjective tpfTestObjective = (TPFTestObjective)theEObject;
				T result = caseTPFTestObjective(tpfTestObjective);
				if (result == null) result = caseCMNNamedElement(tpfTestObjective);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TEST_COMPONENT: {
				TPFTestComponent tpfTestComponent = (TPFTestComponent)theEObject;
				T result = caseTPFTestComponent(tpfTestComponent);
				if (result == null) result = caseCFGClass(tpfTestComponent);
				if (result == null) result = caseCMNNamedElement(tpfTestComponent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TIMEZONE: {
				TPFTimezone tpfTimezone = (TPFTimezone)theEObject;
				T result = caseTPFTimezone(tpfTimezone);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_VALIDATION_ACTION: {
				TPFValidationAction tpfValidationAction = (TPFValidationAction)theEObject;
				T result = caseTPFValidationAction(tpfValidationAction);
				if (result == null) result = caseBVREventOccurrence(tpfValidationAction);
				if (result == null) result = caseBVRInteractionFragment(tpfValidationAction);
				if (result == null) result = caseCMNNamedElement(tpfValidationAction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_EXECUTION_HISTORY: {
				TPFExecutionHistory tpfExecutionHistory = (TPFExecutionHistory)theEObject;
				T result = caseTPFExecutionHistory(tpfExecutionHistory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT: {
				TPFExecutionEvent tpfExecutionEvent = (TPFExecutionEvent)theEObject;
				T result = caseTPFExecutionEvent(tpfExecutionEvent);
				if (result == null) result = caseCMNNamedElement(tpfExecutionEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_EXECUTION_STATUS: {
				TPFExecutionStatus tpfExecutionStatus = (TPFExecutionStatus)theEObject;
				T result = caseTPFExecutionStatus(tpfExecutionStatus);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_INVOCATION_EVENT: {
				TPFInvocationEvent tpfInvocationEvent = (TPFInvocationEvent)theEObject;
				T result = caseTPFInvocationEvent(tpfInvocationEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfInvocationEvent);
				if (result == null) result = caseCMNNamedElement(tpfInvocationEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_VERDICT_EVENT: {
				TPFVerdictEvent tpfVerdictEvent = (TPFVerdictEvent)theEObject;
				T result = caseTPFVerdictEvent(tpfVerdictEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfVerdictEvent);
				if (result == null) result = caseCMNNamedElement(tpfVerdictEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT: {
				TPFMessageEvent tpfMessageEvent = (TPFMessageEvent)theEObject;
				T result = caseTPFMessageEvent(tpfMessageEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfMessageEvent);
				if (result == null) result = caseCMNNamedElement(tpfMessageEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TYPED_EVENT: {
				TPFTypedEvent tpfTypedEvent = (TPFTypedEvent)theEObject;
				T result = caseTPFTypedEvent(tpfTypedEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfTypedEvent);
				if (result == null) result = caseCMNNamedElement(tpfTypedEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TEST: {
				TPFTest tpfTest = (TPFTest)theEObject;
				T result = caseTPFTest(tpfTest);
				if (result == null) result = caseCMNNamedElement(tpfTest);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_LOOP_EVENT: {
				TPFLoopEvent tpfLoopEvent = (TPFLoopEvent)theEObject;
				T result = caseTPFLoopEvent(tpfLoopEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfLoopEvent);
				if (result == null) result = caseCMNNamedElement(tpfLoopEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_TIMED_EVENT: {
				TPFTimedEvent tpfTimedEvent = (TPFTimedEvent)theEObject;
				T result = caseTPFTimedEvent(tpfTimedEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfTimedEvent);
				if (result == null) result = caseCMNNamedElement(tpfTimedEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_WAIT_EVENT: {
				TPFWaitEvent tpfWaitEvent = (TPFWaitEvent)theEObject;
				T result = caseTPFWaitEvent(tpfWaitEvent);
				if (result == null) result = caseTPFTimedEvent(tpfWaitEvent);
				if (result == null) result = caseTPFExecutionEvent(tpfWaitEvent);
				if (result == null) result = caseCMNNamedElement(tpfWaitEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.EOBJECT_REFERENCE: {
				EObjectReference eObjectReference = (EObjectReference)theEObject;
				T result = caseEObjectReference(eObjectReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_VERDICT_LIST: {
				TPFVerdictList tpfVerdictList = (TPFVerdictList)theEObject;
				T result = caseTPFVerdictList(tpfVerdictList);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_REASON_TO_VERDICT_MAP_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<EList<TPFVerdictReason>, TPFVerdict> tpfReasonToVerdictMapEntry = (Map.Entry<EList<TPFVerdictReason>, TPFVerdict>)theEObject;
				T result = caseTPFReasonToVerdictMapEntry(tpfReasonToVerdictMapEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_EXTENDED_REASON_TO_VERDICT_MAP_ENTRY: {
				@SuppressWarnings("unchecked") Map.Entry<EList<ITPFExtendedVerdictReason>, TPFVerdict> tpfExtendedReasonToVerdictMapEntry = (Map.Entry<EList<ITPFExtendedVerdictReason>, TPFVerdict>)theEObject;
				T result = caseTPFExtendedReasonToVerdictMapEntry(tpfExtendedReasonToVerdictMapEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.ITPF_EXTENDED_VERDICT_REASON: {
				ITPFExtendedVerdictReason itpfExtendedVerdictReason = (ITPFExtendedVerdictReason)theEObject;
				T result = caseITPFExtendedVerdictReason(itpfExtendedVerdictReason);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case Common_TestprofilePackage.TPF_REPOSITORY_RECORD: {
				TPFRepositoryRecord tpfRepositoryRecord = (TPFRepositoryRecord)theEObject;
				T result = caseTPFRepositoryRecord(tpfRepositoryRecord);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Deployment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Deployment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFDeployment(TPFDeployment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Literal Anyor Null</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Literal Anyor Null</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFLiteralAnyorNull(TPFLiteralAnyorNull object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Literal Any</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Literal Any</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFLiteralAny(TPFLiteralAny object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Instance Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Instance Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFInstanceValue(TPFInstanceValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Execution Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Execution Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFExecutionResult(TPFExecutionResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Log Action</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Log Action</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFLogAction(TPFLogAction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Default</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Default</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFDefault(TPFDefault object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Default Application</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Default Application</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFDefaultApplication(TPFDefaultApplication object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Behavior</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Behavior</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFBehavior(TPFBehavior object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Test Case</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Test Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTestCase(TPFTestCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Arbiter</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Arbiter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFArbiter(TPFArbiter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Coding Rule</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Coding Rule</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFCodingRule(TPFCodingRule object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPFSUT</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPFSUT</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFSUT(TPFSUT object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Test Suite</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Test Suite</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTestSuite(TPFTestSuite object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Test Objective</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Test Objective</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTestObjective(TPFTestObjective object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Test Component</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Test Component</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTestComponent(TPFTestComponent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Timezone</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Timezone</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTimezone(TPFTimezone object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Validation Action</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Validation Action</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFValidationAction(TPFValidationAction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Execution History</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Execution History</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFExecutionHistory(TPFExecutionHistory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Execution Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Execution Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFExecutionEvent(TPFExecutionEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Execution Status</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Execution Status</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFExecutionStatus(TPFExecutionStatus object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Invocation Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Invocation Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFInvocationEvent(TPFInvocationEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Verdict Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Verdict Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFVerdictEvent(TPFVerdictEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Message Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Message Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFMessageEvent(TPFMessageEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Typed Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Typed Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTypedEvent(TPFTypedEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Test</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Test</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTest(TPFTest object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Loop Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Loop Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFLoopEvent(TPFLoopEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Timed Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Timed Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFTimedEvent(TPFTimedEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Wait Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Wait Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFWaitEvent(TPFWaitEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEObjectReference(EObjectReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Verdict List</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Verdict List</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFVerdictList(TPFVerdictList object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Reason To Verdict Map Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Reason To Verdict Map Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFReasonToVerdictMapEntry(Map.Entry<EList<TPFVerdictReason>, TPFVerdict> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Extended Reason To Verdict Map Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Extended Reason To Verdict Map Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFExtendedReasonToVerdictMapEntry(Map.Entry<EList<ITPFExtendedVerdictReason>, TPFVerdict> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ITPF Extended Verdict Reason</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ITPF Extended Verdict Reason</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseITPFExtendedVerdictReason(ITPFExtendedVerdictReason object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TPF Repository Record</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TPF Repository Record</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTPFRepositoryRecord(TPFRepositoryRecord object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CMN Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CMN Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCMNNamedElement(CMNNamedElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Configurable Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGConfigurableObject(CFGConfigurableObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>BVR Interaction Fragment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>BVR Interaction Fragment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBVRInteractionFragment(BVRInteractionFragment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>BVR Event Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>BVR Event Occurrence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBVREventOccurrence(BVREventOccurrence object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>CFG Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>CFG Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCFGClass(CFGClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //Common_TestprofileSwitch
