/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: InvocationContext.java,v 1.4 2006/03/29 15:08:21 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

/**
 * Represent the context of a method invocation.
 * 
 * @author slavescu
 */
public final class InvocationContext implements Cloneable {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String invocationAgentIdRef = null;
    protected String invocationNodeIdRef = null;
    protected String invocationProcessIdRef = null;
    protected int invocationThreadIdRef;
    protected long invocationSequenceCounter;
    protected long invocationTicket;

	/**
	 * @return the agent ID of this invocation
	 */
	public String getInvocationAgentIdRef() {
		return invocationAgentIdRef;
	}

	/**
	 * @return the node ID of this invocation
	 */
	public String getInvocationNodeIdRef() {
		return invocationNodeIdRef;
	}

	/**
	 * @return the process ID of this invocation
	 */
	public String getInvocationProcessIdRef() {
		return invocationProcessIdRef;
	}

	/**
	 * @return the sequence counter of this invocation
	 */
	public long getInvocationSequenceCounter() {
		return invocationSequenceCounter;
	}

	/**
	 * @return the thread ID of this invocation
	 */
	public int getInvocationThreadIdRef() {
		return invocationThreadIdRef;
	}

	/**
	 * @return the ticket of this invocation
	 */
	public long getInvocationTicket() {
		return invocationTicket;
	}

	/**
	 * @param string
	 */
	public void setInvocationAgentIdRef(String string) {
		invocationAgentIdRef = string;
	}

	/**
	 * @param string
	 */
	public void setInvocationNodeIdRef(String string) {
		invocationNodeIdRef = string;
	}

	/**
	 * @param string
	 */
	public void setInvocationProcessIdRef(String string) {
		invocationProcessIdRef = string;
	}

	/**
	 * @param l
	 */
	public void setInvocationSequenceCounter(long l) {
		invocationSequenceCounter = l;
	}

	/**
	 * @param i
	 */
	public void setInvocationThreadIdRef(int i) {
		invocationThreadIdRef = i;
	}

	/**
	 * @param l
	 */
	public void setInvocationTicket(long l) {
		invocationTicket = l;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

}
