/**********************************************************************
 * Copyright (c) 2008, 2010 Intel Corporation and others.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: ThreadEventsContext.java,v 1.3 2010/05/11 16:30:04 jwest Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/ 

package org.eclipse.hyades.loaders.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadEventsContext {

	private HashMap/*<TRCObject, TRCThreadStartThreadEvent>*/ threadObj2CallStartEventMap = new HashMap();
	
	/** Each thread has a unique ID and Java object associated with it. Map allows to
	 * define thread ID by its ObjRefID. */
	private HashMap/*<TRCObject, TRCThread>*/ object2ThreadMap = new HashMap();
	
	/** Map defines which thread currently owns monitor of object with certain objectIDRef */
	private HashMap/*<TRCObject, TRCThread>*/ monitor2OwnerMap = new HashMap();
	
	private HashMap/*<TRCThread, TRCThreadDeadAndNotifyJoinedEvent>*/ thread2ThreadDeadNotifyEventMap = new HashMap();
	
	private HashMap/*<TRCObject, List<TRCThreadNotifyEvent>>*/ monitor2NotifyMap = new HashMap();
	private HashMap/*<TRCObject, TRCThreadNotifyAllEvent>*/ monitor2NotifyAllMap = new HashMap();
	
	
	private HashMap/*<TRCThread, TRCThreadInterruptThreadEvent>*/ thread2InterruptionMap = new HashMap();

	private Map/*<TRCThread, Long>*/ threadSleepData = Collections.synchronizedMap(new HashMap());
	
	public Map getThreadObj2CallStartEventMap() {
		return threadObj2CallStartEventMap;
	}

	public Map getObject2ThreadMap() {
		return object2ThreadMap;
	}

	public Map getMonitor2OwnerMap() {
		return monitor2OwnerMap;
	}
	
	public Map getThread2ThreadDeadNotifyEventMap() {
		return thread2ThreadDeadNotifyEventMap;
	}

	public Map getMonitor2NotifyMap() {
		return monitor2NotifyMap;
	}

	public Map getMonitor2NotifyAllMap() {
		return monitor2NotifyAllMap;
	}

	public Map getThread2InterruptionMap() {
		return thread2InterruptionMap;
	}

	/** Given a threadID, return a list of entries that contain the time at which the thread began sleeping (only applicable for threads that are sleeping) */
	public List/*<Object> */ getThreadSleepData(long threadId) {
		if(threadSleepData == null) {
			threadSleepData = Collections.synchronizedMap(new HashMap()); 
		}
		
		List<Object> threadEntries = (List<Object>)threadSleepData.get(new Long(threadId));
		if(threadEntries == null) {
			threadEntries = Collections.synchronizedList(new ArrayList/*<Object>*/());
			threadSleepData.put(new Long(threadId), threadEntries);
		}	
		
		return threadEntries;
	}
	
}
