/**********************************************************************
 * Copyright (c) 2003, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceLookupService.java,v 1.8 2006/02/08 19:56:54 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: TraceLookupService.java,v 1.8 2006/02/08 19:56:54 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.hyades.loaders.util.ExtendedLookupService;
import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.util.IntToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.LongToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.internal.IntToObjectMapImpl;
import org.eclipse.hyades.models.hierarchy.util.internal.LongToObjectMapImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.models.trace.impl.TRCProcessImpl;
import org.eclipse.hyades.models.trace.impl.TRCSourceInfoImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 */
public class TraceLookupService extends GenericLookupService implements ExtendedLookupService {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3691040963154031927L;
	//~ Constructors
	// -------------------------------------------------------------------------------
	public TraceLookupService() {
		super();
		types.add(TRCProcessImpl.class);
		types.add(TRCThreadImpl.class);
		types.add(TRCPackageImpl.class);
		types.add(TRCClassImpl.class);
		types.add(TRCClass.class);
		types.add(TRCArrayClassImpl.class);
		types.add(TRCMethodImpl.class);
		types.add(TRCMethodWithLLDataImpl.class);
		types.add(TRCMethod.class);
		types.add(TRCHeapDumpImpl.class);
		types.add(TRCObjectEntry.class);
		types.add(TRCHeapObjectImpl.class);
		types.add(TRCFullTraceObjectImpl.class);
		types.add(TRCFullHeapObjectImpl.class);
		types.add(VirtualObjectInfo.class);
		types.add(TRCSourceInfoImpl.class);
		types.add(TRCSourceInfo.class);
		types.add(TRCFullMethodInvocationImpl.class);
		types.add(CallStackPerThread.class);
	}

	public boolean deregister(HierarchyContext context, Class type, Object key) {
		if (isObjectType(type)) {
			Map typeMap = getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return false;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return false;
			}
			return objectEntry.remove(type);
		}
		return super.deregister(context, type, key);
	}

	public boolean deregister(HierarchyContext context, Class type) {
		if (isObjectType(type)) {
			Map typeMap = getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return false;
			}
			boolean ret = false;
			for (Iterator iter = typeMap.values().iterator(); iter.hasNext();) {
				TRCObjectEntry objectEntry = (TRCObjectEntry) iter.next();
				if (objectEntry.remove(type)) {
					ret = true;
				}
			}
			return ret;
		}
		return super.deregister(context, type);
	}
	protected boolean isObjectType(Class type) {
		return type == TRCHeapObjectImpl.class || type == TRCFullTraceObjectImpl.class || type == TRCFullHeapObjectImpl.class;
	}

	public Object locate(HierarchyContext context, Class type, Object key) {
		if (isObjectType(type)) {
			Map typeMap = getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return null;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return null;
			}
			return objectEntry.get(type);
		}
		return super.locate(context, getEquivalentClass(type), key);
	}
	
	protected Class getEquivalentClass(Class type) {
		if(TRCFullMethodInvocation.class.isAssignableFrom(type))
			return TRCFullMethodInvocationImpl.class;
		if(TRCMethod.class.isAssignableFrom(type))
			return TRCMethod.class;
		if(TRCClass.class.isAssignableFrom(type))
			return TRCClass.class;
		if(TRCSourceInfo.class.isAssignableFrom(type))
			return TRCSourceInfo.class;
		return type;
	}
	
	protected Map getTypeMap(HierarchyContext context, Class type, boolean create) {
		if (isObjectType(type))
			return super.getTypeMap(context, TRCObjectEntry.class, create);
		
		return super.getTypeMap(context, getEquivalentClass(type), create);
	}
	
	protected Map createMap(Class equivalentType) {
		int classNameInt = LoadersUtils.getHashCode(equivalentType.getName());
		switch (classNameInt) {
		case TraceConstants.TRCFullMethodInvocationImpl_int :
//		case TraceConstants.TRCCallerCalleeInvocationInfoImpl_int:
			return new IntToObjectMapImpl();
		case TraceConstants.TRCProcessImpl_int :
			return new IntToObjectMapImpl();
		case TraceConstants.TRCThreadImpl_int :
			return new IntToObjectMapImpl();
//		case TraceConstants.TRCPackageImpl_int :
//			return new IntToObjectMapImpl();
		case TraceConstants.TRCClass_int :
			return new LongToObjectMapImpl();
		case TraceConstants.TRCMethod_int :
			return new IntToObjectMapImpl();
		case TraceConstants.TRCHeapObjectImpl_int :
		case TraceConstants.TRCFullTraceObjectImpl_int :
		case TraceConstants.TRCFullHeapObjectImpl_int :
			return new LongToObjectMapImpl();
		case TraceConstants.TRCObjectEntry_int :
			return new LongToObjectMapImpl();
		case TraceConstants.TRCSourceInfo_int :
			return new IntToObjectMapImpl();
		case TraceConstants.TRCHeapDumpImpl_int :
			return new IntToObjectMapImpl();
		case TraceConstants.CallStackPerThread_int:
			return new IntToObjectMapImpl();
		case TraceConstants.VirtualObjectInfo_int:
			return new LongToObjectMapImpl();
		default :
			break;
		}
		return super.createMap(equivalentType);
	}
	protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
		if (object == null) {
			return false;
		}
		//        Class type = object.getClass();
		int classNameInt = LoadersUtils.getHashCode(getEquivalentClass(type).getName());
		switch (classNameInt) {
			case TraceConstants.TRCFullMethodInvocationImpl_int :
//			case TraceConstants.TRCCallerCalleeInvocationInfoImpl_int:
				TRCFullMethodInvocation inv = (TRCFullMethodInvocation) object;
				if (inv.getThread() == null) {
					return false;
				}
				LongToObjectMap ticketsMap = (LongToObjectMap)((IntToObjectMap)typeMap).get(inv.getThread().getId());
				if(ticketsMap==null)
				{
					ticketsMap = new LongToObjectMapImpl();
					((IntToObjectMap)typeMap).put(inv.getThread().getId(),ticketsMap);
				}
				addOrRemove((LongToObjectMap)ticketsMap, inv.getTicket(), object, remove);
//				String id = TraceUtils.getMethodInvocationId(inv.getThread().getId(),inv.getTicket());
//				addOrRemove((IntToObjectMap)typeMap, LoadersUtils.getHashCode(id), object, remove);
				return true;
			case TraceConstants.TRCProcessImpl_int :
				addOrRemove((IntToObjectMap)typeMap, LoadersUtils.getHashCode(((TRCProcess) object).getId()), object, remove);
				return true;
			case TraceConstants.TRCThreadImpl_int :
				addOrRemove((IntToObjectMap)typeMap, ((TRCThread) object).getId(), object, remove);
				return true;
			case TraceConstants.TRCPackageImpl_int :
				addOrRemove(typeMap,((TRCPackage) object).getName(), object, remove);
				return true;
			case TraceConstants.TRCClass_int :
				addOrRemove((LongToObjectMap)typeMap, ((TRCClass) object).getId(), object, remove);
				return true;
//			case TraceConstants.TRCArrayClassImpl_int :
//				addOrRemove(typeMap, LoadersUtils.getLookUpKey(((TRCArrayClass) object).getId()), object, remove);
//				return true;
			case TraceConstants.TRCMethod_int :
				addOrRemove((IntToObjectMap)typeMap, ((TRCMethod) object).getId(), object, remove);
				return true;
			case TraceConstants.TRCHeapObjectImpl_int :
			case TraceConstants.TRCFullTraceObjectImpl_int :
			case TraceConstants.TRCFullHeapObjectImpl_int :
				long key = ((TRCObject) object).getId();
				TRCObjectEntry objectEntry = (TRCObjectEntry) ((LongToObjectMap)typeMap).get(key);
				if (objectEntry == null) {
					objectEntry = new TRCObjectEntry();
					addOrRemove((LongToObjectMap)typeMap, key, objectEntry, remove);
				}
				objectEntry.put(type, (TRCObject) object);
				return true;
			case TraceConstants.TRCObjectEntry_int :
				addOrRemove((LongToObjectMap)typeMap, ((TRCObjectEntry) object).getId(), object, remove);
				return true;
			//		  case TraceConstants.VirtualObjectInfo_int:
			//			  addOrRemove(typeMap,
			// LoadersUtils.getLookUpKey(((VirtualObjectInfo) object).objId),
			// object, remove);
			//
			//			  return true;
			case TraceConstants.TRCSourceInfo_int :
				addOrRemove((IntToObjectMap)typeMap, LoadersUtils.getHashCode(((TRCSourceInfo) object).getLocation()), object, remove);
				return true;
			case TraceConstants.TRCHeapDumpImpl_int :
				addOrRemove((IntToObjectMap)typeMap, (int)((TRCHeapDump) object).getId(), object, remove);
				return true;
			default :
				break;
		}
		return false;
	}
	public boolean deregister(HierarchyContext context, Class type, int key) {
		if (isObjectType(type)) {
			IntToObjectMap typeMap = (IntToObjectMap)getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return false;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return false;
			}
			return objectEntry.remove(type);
		}
		else
		{
			IntToObjectMap typeMap = (IntToObjectMap)getTypeMap(context, getEquivalentClass(type), false);
			if (typeMap == null) {
				return false;
			}
			typeMap.remove(key);
			return true;
		}		
	}
	public boolean deregister(HierarchyContext context, Class type, long key) {
		if (isObjectType(type)) {
			LongToObjectMap typeMap = (LongToObjectMap)getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return false;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return false;
			}
			return objectEntry.remove(type);
		}
		else
		{
			LongToObjectMap typeMap = (LongToObjectMap)getTypeMap(context, getEquivalentClass(type), false);
			if (typeMap == null) {
				return false;
			}
			typeMap.remove(key);
			return true;
		}
	}
	public Object locate(HierarchyContext context, Class type, int key) {
		if (isObjectType(type)) {
			IntToObjectMap typeMap = (IntToObjectMap)getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return null;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return null;
			}
			return objectEntry.get(type);
		}
		else
		{
			IntToObjectMap typeMap = (IntToObjectMap)getTypeMap(context, getEquivalentClass(type), false);
			if (typeMap == null) {
				return null;
			}
			return typeMap.get(key);
		}

	}
	public Object locate(HierarchyContext context, Class type, long key) {
		if (isObjectType(type)) {
			LongToObjectMap typeMap = (LongToObjectMap)getTypeMap(context, TRCObjectEntry.class, false);
			if (typeMap == null) {
				return null;
			}
			TRCObjectEntry objectEntry = (TRCObjectEntry) typeMap.get(key);
			if (objectEntry == null) {
				return null;
			}
			return objectEntry.get(type);
		}
		else
		{
			LongToObjectMap typeMap = (LongToObjectMap)getTypeMap(context, getEquivalentClass(type), false);
			if (typeMap == null) {
				return null;
			}
			return typeMap.get(key);
		}
	}

}
